/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.pegdown.PegDownProcessor;
import org.pegdown.ToHtmlSerializer;
import org.pegdown.ast.RootNode;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="markdown/1.0")
@Singleton
public class MarkdownParser
implements Parser {
    private static final PegDownProcessor PEGDOWN_PROCESSOR = new PegDownProcessor(65527);
    @Inject
    @Named(value="xhtml/1.0")
    private Parser xhtmlParser;

    public Syntax getSyntax() {
        return Syntax.MARKDOWN_1_0;
    }

    public XDOM parse(Reader source) throws ParseException {
        try {
            RootNode rootNode = PEGDOWN_PROCESSOR.parseMarkdown(IOUtils.toString((Reader)source).toCharArray());
            String markdownAsHtml = new ToHtmlSerializer().toHtml(rootNode);
            String markdownAsProperHtml = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html><body>" + markdownAsHtml + "</body></html>";
            XDOM xdom = this.xhtmlParser.parse((Reader)new StringReader(markdownAsProperHtml));
            return new XDOM(xdom.getChildren(), new MetaData(Collections.singletonMap("syntax", Syntax.MARKDOWN_1_0)));
        }
        catch (IOException e) {
            throw new ParseException("Failed to convert Markdown to HTML", (Throwable)e);
        }
    }
}

