/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.WikiLinkNode;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.markdown.AbstractHTMLPegdownVisitor;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;

public abstract class AbstractLinkAndImagePegdownVisitor
extends AbstractHTMLPegdownVisitor {
    private static final String TITLE_ATTRIBUTE = "title";
    private static final String LINK_OPEN_CHAR = "[";
    private static final String LINK_CLOSE_CHAR = "]";
    @Inject
    @Named(value="link")
    private ResourceReferenceParser linkResourceReferenceParser;
    @Inject
    @Named(value="image")
    private ResourceReferenceParser imageResourceReferenceParser;
    @Inject
    private ComponentManager componentManager;
    private Map<String, ReferenceNode> references = new HashMap<String, ReferenceNode>();

    public void visit(AutoLinkNode autoLinkNode) {
        ResourceReference reference = this.linkResourceReferenceParser.parse(autoLinkNode.getText());
        this.getListener().beginLink(reference, true, Collections.EMPTY_MAP);
        this.getListener().endLink(reference, true, Collections.EMPTY_MAP);
    }

    public void visit(ExpImageNode expImageNode) {
        ResourceReference reference = this.imageResourceReferenceParser.parse(expImageNode.url);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String computedAltValue = this.computeAltAttributeValue(reference);
        String extractedAltValue = this.extractText((Node)expImageNode);
        if (StringUtils.isNotEmpty((CharSequence)extractedAltValue) && !extractedAltValue.equals(computedAltValue)) {
            parameters.put("alt", extractedAltValue);
        }
        this.addTitle(parameters, expImageNode.title);
        this.getListener().onImage(reference, false, parameters);
    }

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.getInstance(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }

    public void visit(ExpLinkNode expLinkNode) {
        ResourceReference reference = this.linkResourceReferenceParser.parse(expLinkNode.url);
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addTitle(parameters, expLinkNode.title);
        this.getListener().beginLink(reference, false, parameters);
        this.visitChildren((Node)expLinkNode);
        this.getListener().endLink(reference, false, parameters);
    }

    private void addTitle(Map<String, String> parameters, String title) {
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            parameters.put(TITLE_ATTRIBUTE, title);
        }
    }

    public void visit(MailLinkNode mailLinkNode) {
        ResourceReference reference = this.linkResourceReferenceParser.parse("mailto:" + mailLinkNode.getText());
        this.getListener().beginLink(reference, true, Collections.EMPTY_MAP);
        this.getListener().endLink(reference, true, Collections.EMPTY_MAP);
    }

    public void visit(ReferenceNode referenceNode) {
        this.references.put(this.extractText((Node)referenceNode), referenceNode);
    }

    public void visit(RefImageNode refImageNode) {
        String label = this.extractText((Node)refImageNode.referenceKey);
        ReferenceNode referenceNode = this.references.get(label);
        if (referenceNode != null) {
            ResourceReference reference = this.imageResourceReferenceParser.parse(referenceNode.getUrl());
            Map<String, String> parameters = Collections.EMPTY_MAP;
            if (StringUtils.isNotEmpty((CharSequence)referenceNode.getTitle())) {
                parameters = Collections.singletonMap(TITLE_ATTRIBUTE, referenceNode.getTitle());
            }
            this.getListener().onImage(reference, false, parameters);
        }
    }

    public void visit(RefLinkNode refLinkNode) {
        String key = refLinkNode.referenceKey == null ? this.extractText((Node)refLinkNode) : this.extractText((Node)refLinkNode.referenceKey);
        ReferenceNode referenceNode = this.references.get(key);
        if (referenceNode != null) {
            ResourceReference reference = this.linkResourceReferenceParser.parse(referenceNode.getUrl());
            Map<String, String> parameters = Collections.EMPTY_MAP;
            if (StringUtils.isNotEmpty((CharSequence)referenceNode.getTitle())) {
                parameters = Collections.singletonMap(TITLE_ATTRIBUTE, referenceNode.getTitle());
            }
            this.getListener().beginLink(reference, false, parameters);
            this.visitChildren((Node)refLinkNode);
            this.getListener().endLink(reference, false, parameters);
        } else {
            this.visit(LINK_OPEN_CHAR);
            this.visitChildren((Node)refLinkNode);
            this.visit(LINK_CLOSE_CHAR);
            if (refLinkNode.separatorSpace != null) {
                this.visit(refLinkNode.separatorSpace);
                this.visit(LINK_OPEN_CHAR);
                if (refLinkNode.referenceKey != null) {
                    this.visit(key);
                }
                this.visit(LINK_CLOSE_CHAR);
            }
        }
    }

    public void visit(WikiLinkNode wikiLinkNode) {
        ResourceReference reference = this.linkResourceReferenceParser.parse(wikiLinkNode.getText());
        this.getListener().beginLink(reference, false, Collections.EMPTY_MAP);
        this.getListener().endLink(reference, false, Collections.EMPTY_MAP);
    }
}

