/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.xwiki.rendering.internal.parser.markdown.AbstractPegdownVisitor;
import org.xwiki.rendering.internal.parser.markdown.QuoteListener;
import org.xwiki.rendering.listener.InlineFilterListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractTextPegdownVisitor
extends AbstractPegdownVisitor {
    private static final String CODE_MACRO_ID = "code";
    private static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("&[^\\s]*;");
    private Map<String, AbbreviationNode> abbreviations = new HashMap<String, AbbreviationNode>();
    private boolean isHandlingAbbreviations;

    public void visit(ParaNode paraNode) {
        this.getListener().beginParagraph(Collections.EMPTY_MAP);
        this.visitChildren((Node)paraNode);
        this.getListener().endParagraph(Collections.EMPTY_MAP);
    }

    public void visit(TextNode textNode) {
        boolean foundAbbreviation = false;
        if (!this.isHandlingAbbreviations) {
            for (Map.Entry<String, AbbreviationNode> abbreviationEntry : this.abbreviations.entrySet()) {
                int pos = textNode.getText().indexOf(abbreviationEntry.getKey());
                if (pos <= -1) continue;
                this.visit(new TextNode(textNode.getText().substring(0, pos)));
                this.isHandlingAbbreviations = true;
                String abbreviationDefinition = this.extractText(abbreviationEntry.getValue().getExpansion());
                this.isHandlingAbbreviations = false;
                String html = StringUtils.isNotEmpty((CharSequence)abbreviationDefinition) ? String.format("<abbr title=\"%s\">%s</abbr>", abbreviationDefinition, abbreviationEntry.getKey()) : String.format("<abbr>%s</abbr>", abbreviationEntry.getKey());
                this.getListener().onRawText(html, Syntax.HTML_4_01);
                this.visit(new TextNode(textNode.getText().substring(pos + abbreviationEntry.getKey().length())));
                foundAbbreviation = true;
                break;
            }
        }
        if (!foundAbbreviation) {
            Matcher matcher = HTML_ENTITY_PATTERN.matcher(textNode.getText());
            if (matcher.find()) {
                if (matcher.start() > 0) {
                    this.visit(textNode.getText().substring(0, matcher.start()));
                }
                this.getListener().onRawText(matcher.group(), Syntax.HTML_4_01);
                if (matcher.end() < textNode.getText().length()) {
                    this.visit(new TextNode(textNode.getText().substring(matcher.end())));
                }
            } else {
                this.visit(textNode.getText());
            }
        }
    }

    protected void visit(String text) {
        try {
            InlineFilterListener inlineListener = new InlineFilterListener();
            inlineListener.setWrappedListener(this.getListener());
            this.plainTextStreamParser.parse((Reader)new StringReader(text), (Listener)inlineListener);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Error parsing content [%s]", text), e);
        }
    }

    public void visit(SpecialTextNode specialTextNode) {
        this.visit(specialTextNode.getText());
    }

    public void visit(CodeNode codeNode) {
        this.getListener().onMacro(CODE_MACRO_ID, Collections.EMPTY_MAP, codeNode.getText(), true);
    }

    public void visit(VerbatimNode verbatimNode) {
        String text = StringUtils.removeEnd((String)verbatimNode.getText(), (String)"\n");
        Map<String, String> parameters = verbatimNode.getType().length() > 0 ? Collections.singletonMap("language", verbatimNode.getType()) : Collections.EMPTY_MAP;
        this.getListener().onMacro(CODE_MACRO_ID, parameters, text, false);
    }

    public void visit(BlockQuoteNode blockQuoteNode) {
        this.getListener().beginQuotation(Collections.EMPTY_MAP);
        QuoteListener quoteListener = new QuoteListener();
        quoteListener.setWrappedListener(this.getListener());
        this.listeners.push(quoteListener);
        this.visitChildren((Node)blockQuoteNode);
        this.listeners.pop();
        quoteListener.closeOpenedQuotationLines();
        this.getListener().endQuotation(Collections.EMPTY_MAP);
    }

    public void visit(QuotedNode quotedNode) {
        switch (quotedNode.getType()) {
            case DoubleAngle: {
                this.getListener().onSpecialSymbol('\u201c');
                this.visitChildren((Node)quotedNode);
                this.getListener().onSpecialSymbol('\u201d');
                break;
            }
            case Single: {
                this.getListener().onSpecialSymbol('\'');
                this.visitChildren((Node)quotedNode);
                this.getListener().onSpecialSymbol('\'');
                break;
            }
            default: {
                this.getListener().onSpecialSymbol('\"');
                this.visitChildren((Node)quotedNode);
                this.getListener().onSpecialSymbol('\"');
            }
        }
    }

    public void visit(SimpleNode simpleNode) {
        switch (simpleNode.getType()) {
            case Linebreak: {
                this.getListener().onNewLine();
                break;
            }
            case Apostrophe: {
                this.getListener().onSpecialSymbol('\'');
                break;
            }
            case HRule: {
                this.getListener().onHorizontalLine(Collections.EMPTY_MAP);
                break;
            }
            case Endash: {
                this.getListener().onSpecialSymbol('\u2013');
                break;
            }
            case Emdash: {
                this.getListener().onSpecialSymbol('\u2014');
                break;
            }
            case Ellipsis: {
                this.getListener().onSpecialSymbol('\u2026');
                break;
            }
            default: {
                this.getListener().onSpace();
            }
        }
    }

    public void visit(AbbreviationNode abbreviationNode) {
        this.isHandlingAbbreviations = true;
        this.abbreviations.put(this.extractText((Node)abbreviationNode), abbreviationNode);
        this.isHandlingAbbreviations = false;
    }
}

