/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.markdown11;

import java.io.Reader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.pegdown.PegDownProcessor;
import org.pegdown.plugins.PegDownPlugins;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.parser.markdown.AbstractMarkdownStreamParser;
import org.xwiki.rendering.internal.parser.markdown.PegdownVisitor;
import org.xwiki.rendering.internal.parser.markdown11.FormattingPegdownPluginParser;
import org.xwiki.rendering.internal.parser.markdown11.InlineXHtmlPegdownPluginParser;
import org.xwiki.rendering.internal.parser.markdown11.MacroPegdownPluginParser;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="markdown/1.1")
@Singleton
public class Markdown11StreamParser
extends AbstractMarkdownStreamParser {
    @Inject
    @Named(value="markdown/1.1")
    private PegdownVisitor pegdownVisitor;

    public Syntax getSyntax() {
        return Syntax.MARKDOWN_1_1;
    }

    protected PegdownVisitor getPegdownVisitor() {
        return this.pegdownVisitor;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        PegDownPlugins plugins = PegDownPlugins.builder().withPlugin(FormattingPegdownPluginParser.class, new Object[0]).withPlugin(MacroPegdownPluginParser.class, new Object[0]).withPlugin(InlineXHtmlPegdownPluginParser.class, new Object[0]).withSpecialChars(new Character[]{Character.valueOf('^')}).build();
        PegDownProcessor processor = new PegDownProcessor(65525, plugins);
        this.parse(processor, source, listener);
    }
}

