/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.wikimodel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.wikimodel.IWemConstants;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;

public class WikiModelGeneratorListener
implements Listener {
    private IWemListener wikimodelListener;
    private int docLevel = 1;
    private Deque<Context> context = new ArrayDeque<Context>();

    public WikiModelGeneratorListener(IWemListener wikimodelListener) {
        this.wikimodelListener = wikimodelListener;
    }

    private Context getContext() {
        return this.context.peek();
    }

    private Context pushContext() {
        Context ctx = new Context();
        this.context.push(ctx);
        return ctx;
    }

    private Context popContext() {
        return this.context.pop();
    }

    public void beginDocument(MetaData metadata) {
        this.pushContext();
        this.wikimodelListener.beginDocument(WikiParameters.EMPTY);
        this.wikimodelListener.beginSection(this.docLevel++, this.getContext().headerLevel++, WikiParameters.EMPTY);
    }

    public void endDocument(MetaData metadata) {
        this.wikimodelListener.endSection(this.docLevel--, this.getContext().headerLevel, WikiParameters.EMPTY);
        this.wikimodelListener.endDocument(WikiParameters.EMPTY);
        this.popContext();
    }

    public void beginGroup(Map<String, String> parameters) {
        this.wikimodelListener.beginDocument(this.createWikiParameters(parameters));
    }

    public void endGroup(Map<String, String> parameters) {
        this.wikimodelListener.endDocument(this.createWikiParameters(parameters));
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.STRONG, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case ITALIC: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.EM, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case STRIKEDOUT: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.STRIKE, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case UNDERLINED: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.INS, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case MONOSPACE: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.MONO, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUBSCRIPT: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.SUB, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUPERSCRIPT: {
                this.wikimodelListener.beginFormat(new WikiFormat(IWemConstants.SUP, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case NONE: {
                this.wikimodelListener.beginFormat(new WikiFormat((Collection)this.createWikiParameters(parameters).toList()));
            }
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.STRONG, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case ITALIC: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.EM, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case STRIKEDOUT: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.STRIKE, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case UNDERLINED: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.INS, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case MONOSPACE: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.MONO, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUBSCRIPT: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.SUB, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case SUPERSCRIPT: {
                this.wikimodelListener.endFormat(new WikiFormat(IWemConstants.SUP, (Collection)this.createWikiParameters(parameters).toList()));
                break;
            }
            case NONE: {
                this.wikimodelListener.endFormat(new WikiFormat((Collection)this.createWikiParameters(parameters).toList()));
            }
        }
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        this.wikimodelListener.beginList(this.createWikiParameters(parameters), type == ListType.NUMBERED);
    }

    public void beginListItem() {
        this.wikimodelListener.beginListItem();
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.wikimodelListener.beginParagraph(this.createWikiParameters(parameters));
    }

    public void beginSection(Map<String, String> parameters) {
        this.wikimodelListener.beginSection(this.docLevel, this.getContext().headerLevel++, this.createWikiParameters(parameters));
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.wikimodelListener.beginHeader(level.getAsInt(), this.createWikiParameters(parameters));
    }

    public void endList(ListType type, Map<String, String> parameters) {
        this.wikimodelListener.endList(this.createWikiParameters(parameters), type == ListType.NUMBERED);
    }

    public void endListItem() {
        this.wikimodelListener.endListItem();
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void endParagraph(Map<String, String> parameters) {
        this.wikimodelListener.endParagraph(this.createWikiParameters(parameters));
    }

    public void endSection(Map<String, String> parameters) {
        this.wikimodelListener.beginSection(this.docLevel, this.getContext().headerLevel--, this.createWikiParameters(parameters));
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.wikimodelListener.endHeader(level.getAsInt(), this.createWikiParameters(parameters));
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
        if (inline) {
            this.wikimodelListener.onMacroInline(id, this.createWikiParameters(parameters), content);
        } else {
            this.wikimodelListener.onMacroBlock(id, this.createWikiParameters(parameters), content);
        }
    }

    public void onNewLine() {
        this.wikimodelListener.onNewLine();
    }

    public void onSpace() {
        this.wikimodelListener.onSpace(" ");
    }

    public void onSpecialSymbol(char symbol) {
        this.wikimodelListener.onSpecialSymbol("" + symbol);
    }

    public void onWord(String word) {
        this.wikimodelListener.onWord(word);
    }

    public void onId(String name) {
        this.wikimodelListener.onExtensionBlock("xwiki_id", this.createWikiParameters(Collections.singletonMap("name", name)));
    }

    public void onRawText(String text, Syntax syntax) {
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.wikimodelListener.onHorizontalLine(this.createWikiParameters(parameters));
    }

    public void onEmptyLines(int count) {
        this.wikimodelListener.onEmptyLines(count);
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        if (inline) {
            this.wikimodelListener.onVerbatimInline(content, WikiParameters.EMPTY);
        } else {
            this.wikimodelListener.onVerbatimBlock(content, this.createWikiParameters(parameters));
        }
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.wikimodelListener.beginDefinitionList(this.createWikiParameters(parameters));
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.wikimodelListener.endDefinitionList(this.createWikiParameters(parameters));
    }

    public void beginDefinitionTerm() {
        this.wikimodelListener.beginDefinitionTerm();
    }

    public void beginDefinitionDescription() {
        this.wikimodelListener.beginDefinitionDescription();
    }

    public void endDefinitionTerm() {
        this.wikimodelListener.endDefinitionTerm();
    }

    public void endDefinitionDescription() {
        this.wikimodelListener.endDefinitionDescription();
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.wikimodelListener.beginQuotation(this.createWikiParameters(parameters));
    }

    public void endQuotation(Map<String, String> parameters) {
        this.wikimodelListener.endQuotation(this.createWikiParameters(parameters));
    }

    public void beginQuotationLine() {
        this.wikimodelListener.beginQuotationLine();
    }

    public void endQuotationLine() {
        this.wikimodelListener.endQuotationLine();
    }

    public void beginTable(Map<String, String> parameters) {
        this.wikimodelListener.beginTable(this.createWikiParameters(parameters));
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.wikimodelListener.beginTableCell(false, this.createWikiParameters(parameters));
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.wikimodelListener.beginTableCell(true, this.createWikiParameters(parameters));
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.wikimodelListener.beginTableRow(this.createWikiParameters(parameters));
    }

    public void endTable(Map<String, String> parameters) {
        this.wikimodelListener.endTable(this.createWikiParameters(parameters));
    }

    public void endTableCell(Map<String, String> parameters) {
        this.wikimodelListener.endTableCell(false, this.createWikiParameters(parameters));
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.wikimodelListener.endTableCell(true, this.createWikiParameters(parameters));
    }

    public void endTableRow(Map<String, String> parameters) {
        this.wikimodelListener.endTableRow(this.createWikiParameters(parameters));
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
    }

    public void beginMetaData(MetaData metadata) {
    }

    public void endMetaData(MetaData metadata) {
    }

    private WikiParameters createWikiParameters(Map<String, String> parameters) {
        ArrayList<WikiParameter> wikiParams = new ArrayList<WikiParameter>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            wikiParams.add(new WikiParameter(entry.getKey(), entry.getValue()));
        }
        return new WikiParameters(wikiParams);
    }

    private class Context {
        int headerLevel;

        private Context() {
        }
    }
}

