/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxmlcurrent.internal.parameter;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.SaxWriter;
import java.lang.reflect.Type;
import org.apache.commons.lang3.ObjectUtils;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.rendering.xdomxmlcurrent.internal.XDOMXMLCurrentUtils;
import org.xwiki.rendering.xdomxmlcurrent.internal.parameter.ParameterManager;
import org.xwiki.rendering.xdomxmlcurrent.internal.parameter.XDOMXMLCollectionConverter;
import org.xwiki.rendering.xdomxmlcurrent.internal.parameter.XDOMXMLMapConverter;
import org.xwiki.rendering.xdomxmlcurrent.internal.parameter.XDOMXMLTreeMarshallingStrategy;

@Component
public class XStreamParameterManager
implements ParameterManager,
Initializable {
    private XStream xstream;

    public void initialize() throws InitializationException {
        this.xstream = new XStream();
        this.xstream.setMarshallingStrategy((MarshallingStrategy)new XDOMXMLTreeMarshallingStrategy());
        this.xstream.registerConverter((Converter)new XDOMXMLCollectionConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new XDOMXMLMapConverter(this.xstream.getMapper()));
    }

    @Override
    public void serialize(Type type, Object object, ContentHandler xmlContent) {
        Class typeClass = ReflectionUtils.getTypeClass((Type)type);
        if (typeClass != null && ObjectUtils.equals((Object)XDOMXMLCurrentUtils.defaultValue(typeClass), (Object)object)) {
            return;
        }
        SaxWriter saxWriter = new SaxWriter(false);
        saxWriter.setContentHandler(xmlContent);
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        dataHolder.put((Object)"type", (Object)type);
        this.xstream.marshal(object, (HierarchicalStreamWriter)saxWriter, (DataHolder)dataHolder);
    }

    @Override
    public Object unSerialize(Type type, Element rootElement) {
        Object value;
        if (type != null && !rootElement.hasChildNodes() && (value = XDOMXMLCurrentUtils.defaultValue(ReflectionUtils.getTypeClass((Type)type))) != null) {
            return value;
        }
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        dataHolder.put((Object)"type", (Object)type);
        return this.xstream.unmarshal((HierarchicalStreamReader)new DomReader(rootElement), null, (DataHolder)dataHolder);
    }
}

