/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiMacroHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.xhtml.handler.SpanTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class XWikiSpanTagHandler
extends SpanTagHandler
implements XWikiWikiModelHandler {
    private XWikiMacroHandler xWikiMacroHandler;

    public XWikiSpanTagHandler(ComponentManager componentManager, XHTMLParser parser) {
        this.xWikiMacroHandler = new XWikiMacroHandler(componentManager, parser);
    }

    protected void begin(TagContext context) {
        WikiParameters params = context.getParams();
        boolean withNonGeneratedContent = this.xWikiMacroHandler.handleBegin(context);
        if (!withNonGeneratedContent) {
            WikiParameter classParam = params.getParameter("class");
            if (classParam != null) {
                if (classParam.getValue().contains("wikigeneratedlinkcontent")) {
                    this.setAccumulateContent(true);
                } else if (!("wikilink".equals(classParam.getValue()) || "wikicreatelink".equals(classParam.getValue()) || "wikiexternallink".equals(classParam.getValue()))) {
                    if ("xwikirenderingerror".equals(classParam.getValue())) {
                        this.setAccumulateContent(true);
                    } else {
                        super.begin(context);
                    }
                }
            } else {
                super.begin(context);
            }
        }
    }

    protected void end(TagContext context) {
        boolean nonGeneratedContent = this.xWikiMacroHandler.handleEnd(context);
        if (!nonGeneratedContent) {
            WikiParameter classParam = context.getParams().getParameter("class");
            if (classParam != null) {
                if (classParam.getValue().contains("wikigeneratedlinkcontent")) {
                    this.setAccumulateContent(false);
                } else if (!("wikilink".equals(classParam.getValue()) || "wikicreatelink".equals(classParam.getValue()) || "wikiexternallink".equals(classParam.getValue()))) {
                    if ("xwikirenderingerror".equals(classParam.getValue())) {
                        this.setAccumulateContent(false);
                    } else {
                        super.end(context);
                    }
                }
            } else {
                super.end(context);
            }
        }
    }
}

