/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.xhtml.handler.ImgTagHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;

public class XWikiImageTagHandler
extends ImgTagHandler {
    public void initialize(XhtmlHandler.TagStack stack) {
        stack.setStackParameter("isInImage", (Object)false);
        stack.setStackParameter("isFreeStandingImage", (Object)false);
        stack.setStackParameter("imageParameters", (Object)WikiParameters.EMPTY);
    }

    protected void begin(XhtmlHandler.TagStack.TagContext context) {
        boolean isInImage = (Boolean)context.getTagStack().getStackParameter("isInImage");
        if (isInImage) {
            if (this.isFreeStandingReference(context)) {
                context.getTagStack().setStackParameter("isFreeStandingImage", (Object)true);
            } else {
                context.getTagStack().setStackParameter("imageParameters", (Object)this.removeMeaningfulParameters(context.getParams()));
            }
        } else {
            super.begin(context);
        }
    }

    protected void end(XhtmlHandler.TagStack.TagContext context) {
        WikiParameter src;
        boolean isInImage = (Boolean)context.getTagStack().getStackParameter("isInImage");
        if (!isInImage && (src = context.getParams().getParameter("src")) != null) {
            WikiParameters parameters = context.getParams().remove("src");
            if (this.isFreeStandingReference(context)) {
                context.getScannerContext().onImage(src.getValue());
            } else {
                WikiReference reference = new WikiReference(src.getValue(), null, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onImage(reference);
            }
        }
    }

    protected WikiParameters removeMeaningfulParameters(WikiParameters parameters) {
        boolean isFreeStanding;
        WikiParameter classParam = parameters.getParameter("class");
        boolean bl = isFreeStanding = classParam != null && classParam.getValue().equalsIgnoreCase("wikimodel-freestanding");
        if (isFreeStanding) {
            return this.removeFreestanding(parameters).remove("alt").remove("src");
        }
        return this.removeFreestanding(parameters).remove("src");
    }
}

