/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import org.junit.Assert;
import org.junit.Test;
import org.xwiki.rendering.internal.renderer.ParametersPrinter;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.test.jmock.AbstractComponentTestCase;

public class XHTMLMarkerResourceReferenceParserTest
extends AbstractComponentTestCase {
    private ResourceReferenceParser parser;

    protected void registerComponents() throws Exception {
        this.parser = (ResourceReferenceParser)this.getComponentManager().getInstance(ResourceReferenceParser.class, "xhtmlmarker");
    }

    @Test
    public void testParse() {
        ResourceReference expected = new ResourceReference("reference", ResourceType.DOCUMENT);
        expected.setParameter("param1", "value1");
        expected.setParameter("param2", "value2");
        Assert.assertEquals((Object)expected, (Object)this.parser.parse("true|-|doc|-|reference|-|param1=value1 param2=value2"));
    }

    @Test
    public void testParseWithEscapesInParameterValues() {
        ResourceReference expected = new ResourceReference("reference", ResourceType.DOCUMENT);
        expected.setParameter("param", "va\"l\\=ue");
        ParametersPrinter printer = new ParametersPrinter();
        Assert.assertEquals((Object)expected, (Object)this.parser.parse("true|-|doc|-|reference|-|" + printer.print("param", "va\"l\\=ue", '\\')));
    }
}

