/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.test.jmock.AbstractComponentTestCase;

public class XHTMLRendererTest
extends AbstractComponentTestCase {
    private PrintRenderer renderer;
    private WikiModel mockWikiModel;

    protected void registerComponents() throws Exception {
        this.mockWikiModel = (WikiModel)this.getMockery().mock(WikiModel.class);
        DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
        cd.setRoleType(WikiModel.class);
        this.getComponentManager().registerComponent((ComponentDescriptor)cd, (Object)this.mockWikiModel);
        this.renderer = (PrintRenderer)this.getComponentManager().getInstance(PrintRenderer.class, "xhtml/1.0");
    }

    @Test
    public void testBeginLinkHasBaseResourceReferencePassedWhenSourceMetaDataAdded() {
        ResourceReference blockReference = new ResourceReference("reference", ResourceType.DOCUMENT);
        List<Block> linkBlocks = Arrays.asList(new LinkBlock(Arrays.asList(new WordBlock("label")), blockReference, true));
        MetaData metaData1 = new MetaData();
        metaData1.addMetaData("base", (Object)"base1");
        MetaData metaData2 = new MetaData();
        metaData2.addMetaData("base", (Object)"base2");
        XDOM xdom = new XDOM(Arrays.asList(new MetaDataBlock(Arrays.asList(new MetaDataBlock(linkBlocks, metaData2)), metaData1)));
        this.getMockery().checking((ExpectationBuilder)new Expectations(){
            {
                ResourceReference reference = new ResourceReference("reference", ResourceType.DOCUMENT);
                reference.addBaseReference("base1");
                reference.addBaseReference("base2");
                ((WikiModel)this.oneOf(XHTMLRendererTest.this.mockWikiModel)).isDocumentAvailable(reference);
                this.will(1.returnValue((Object)true));
                ((WikiModel)this.oneOf(XHTMLRendererTest.this.mockWikiModel)).getDocumentViewURL(reference);
                this.will(1.returnValue((Object)"viewurl"));
            }
        });
        this.renderer.setPrinter((WikiPrinter)new DefaultWikiPrinter());
        xdom.traverse((Listener)this.renderer);
    }

    @Test
    public void testBeginLinkDoesntUseSourceMetaDataIfBaseReferenceSpecified() {
        ResourceReference blockReference = new ResourceReference("reference", ResourceType.DOCUMENT);
        blockReference.addBaseReference("original base");
        List<Block> linkBlocks = Arrays.asList(new LinkBlock(Arrays.asList(new WordBlock("label")), blockReference, true));
        MetaData metaData = new MetaData();
        metaData.addMetaData("base", (Object)"base");
        XDOM xdom = new XDOM(Arrays.asList(new MetaDataBlock(linkBlocks, metaData)));
        this.getMockery().checking((ExpectationBuilder)new Expectations(){
            {
                ResourceReference reference = new ResourceReference("reference", ResourceType.DOCUMENT);
                reference.addBaseReference("original base");
                ((WikiModel)this.oneOf(XHTMLRendererTest.this.mockWikiModel)).isDocumentAvailable(reference);
                this.will(2.returnValue((Object)true));
                ((WikiModel)this.oneOf(XHTMLRendererTest.this.mockWikiModel)).getDocumentViewURL(reference);
                this.will(2.returnValue((Object)"viewurl"));
            }
        });
        this.renderer.setPrinter((WikiPrinter)new DefaultWikiPrinter());
        xdom.traverse((Listener)this.renderer);
    }

    @Test
    public void testOnImageHasBaseResourceReferencePassedWhenSourceMetaDataAdded() {
        ResourceReference blockReference = new ResourceReference("reference", ResourceType.ATTACHMENT);
        List<Block> imageBlocks = Arrays.asList(new ImageBlock(blockReference, true));
        MetaData metaData = new MetaData();
        metaData.addMetaData("base", (Object)"base");
        XDOM xdom = new XDOM(Arrays.asList(new MetaDataBlock(imageBlocks, metaData)));
        this.getMockery().checking((ExpectationBuilder)new Expectations(){
            {
                ResourceReference reference = new ResourceReference("reference", ResourceType.ATTACHMENT);
                reference.addBaseReference("base");
                ((WikiModel)this.oneOf(XHTMLRendererTest.this.mockWikiModel)).getImageURL(reference, Collections.emptyMap());
                this.will(3.returnValue((Object)"imageurl"));
            }
        });
        this.renderer.setPrinter((WikiPrinter)new DefaultWikiPrinter());
        xdom.traverse((Listener)this.renderer);
    }

    @Test
    public void testOnImageDoesntUseSourceMetaDataIfBaseReferenceSpecified() {
        ResourceReference blockReference = new ResourceReference("reference", ResourceType.ATTACHMENT);
        blockReference.addBaseReference("original base");
        List<Block> imageBlocks = Arrays.asList(new ImageBlock(blockReference, true));
        MetaData metaData = new MetaData();
        metaData.addMetaData("base", (Object)"base");
        XDOM xdom = new XDOM(Arrays.asList(new MetaDataBlock(imageBlocks, metaData)));
        this.getMockery().checking((ExpectationBuilder)new Expectations(){
            {
                ResourceReference reference = new ResourceReference("reference", ResourceType.ATTACHMENT);
                reference.addBaseReference("original base");
                ((WikiModel)this.oneOf(XHTMLRendererTest.this.mockWikiModel)).getImageURL(reference, Collections.emptyMap());
                this.will(4.returnValue((Object)"imageurl"));
            }
        });
        this.renderer.setPrinter((WikiPrinter)new DefaultWikiPrinter());
        xdom.traverse((Listener)this.renderer);
    }
}

