/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import javax.inject.Named;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;

/**
 * Handle XHTML rendering for links to spaces.
 *
 * @version $Id: 730e8f7cd1f9920c4f945660da7f7a32f3035734 $
 * @since 7.4.1, 8.0M1
 */
@Component
@Named("space")
@InstantiationStrategy(ComponentInstantiationStrategy.PER_LOOKUP)
public class SpaceXHTMLLinkTypeRenderer extends DocumentXHTMLLinkTypeRenderer
{
    // Since we can`t currently have more than one @Named annotation on a component (until we get java 8), we need to
    // add this class instead which just extends DocumentXHTMLLinkTypeRenderer and uses a different @Named annotation.
}
