/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Pattern;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractSyntaxFilter;

/**
 * Convert 1.0 bold syntax into 2.0 bold syntax.
 * 
 * @version $Id: BoldSyntaxFilter.java 18134 2009-03-30 13:46:06Z vmassol $
 * @since 1.8M1
 */
@Component("bold")
public class BoldSyntaxFilter extends AbstractSyntaxFilter implements Initializable
{
    private static final Pattern BOLDSYNTAX_PATTERN =
        Pattern.compile("(?<!\\*)\\*([^\\p{Space}](?:[^*\n]*+|\\*)*?(?<=[^\\p{Space}]))\\*(?!\\*)");

    /**
     * {@inheritDoc}
     * @see Initializable#initialize()
     */
    public void initialize() throws InitializationException
    {
        setPriority(1000);
    }

    public BoldSyntaxFilter()
    {
        super(BOLDSYNTAX_PATTERN, "**");
    }
}
