/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component(value="groovy")
public class GroovyFilter
extends AbstractFilter
implements Initializable {
    public static final String GROOVY_BEGIN = "<%";
    public static final String GROOVY_END = "%>";

    public void initialize() throws InitializationException {
        this.setPriority(30);
    }

    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        String currentContent = content;
        int index = currentContent.indexOf(GROOVY_BEGIN);
        while (index != -1) {
            String groovyContent;
            result.append(currentContent.substring(0, index));
            currentContent = currentContent.substring(index + 2);
            int endIndex = currentContent.indexOf(GROOVY_END);
            if (endIndex != -1) {
                groovyContent = currentContent.substring(0, endIndex);
                currentContent = currentContent.substring(endIndex + GROOVY_END.length());
            } else {
                groovyContent = currentContent;
                currentContent = "";
            }
            if (groovyContent.trim().length() > 0) {
                boolean newline = currentContent.startsWith("\n");
                result.append(filterContext.addProtectedContent("{{groovy}}" + groovyContent + "{{/groovy}}", !newline));
                if (newline) {
                    currentContent = CleanUtil.setLeadingNewLines(currentContent, 2);
                }
            }
            index = currentContent.indexOf(GROOVY_BEGIN);
        }
        result.append(currentContent);
        return result.toString();
    }
}

