/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10.macro;

import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.AbstractRadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component(value="quote")
public class QuoteRadeoxMacroConverter
extends AbstractRadeoxMacroConverter {
    @Requirement(value="standalonenewlinecleanning")
    private Filter standaloneNewLineCleaningFilter;

    public String convert(String name, RadeoxMacroParameters parameters, String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)content.replaceAll("[ \t]", ""))) {
            result.append(">");
            result.append(CleanUtil.removeTrailingNewLines(CleanUtil.removeLeadingNewLines(this.standaloneNewLineCleaningFilter.filter(content, filterContext))).replaceAll("\n", "\n>"));
        }
        return result.toString();
    }

    public boolean supportContent() {
        return true;
    }

    public boolean isInline() {
        return false;
    }
}

