/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;

@Component(value="escape")
public class EscapeFilter
extends AbstractFilter
implements Initializable {
    public static final Pattern ESCAPE_PATTERN = Pattern.compile("\\\\(\\\\\\\\)(?!\\\\)|\\\\(.)");
    public static final String ESCAPE_SUFFIX = "escape";

    public void initialize() throws InitializationException {
        this.setPriority(25);
    }

    public String filter(String content, FilterContext filterContext) {
        return this.filter(content, filterContext, true);
    }

    public String filter(String content, FilterContext filterContext, boolean clean) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = ESCAPE_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            result.append(content.substring(currentIndex, matcher.start()));
            if (clean) {
                if (matcher.group(2) != null) {
                    String escaped = matcher.group(2);
                    if ("\\".equals(escaped)) {
                        result.append("\\\\");
                    } else {
                        result.append(filterContext.addProtectedContent(matcher.group(2), ESCAPE_SUFFIX, true));
                    }
                } else {
                    result.append(filterContext.addProtectedContent("\\", ESCAPE_SUFFIX, true));
                }
            } else {
                result.append(filterContext.addProtectedContent(matcher.group(0), ESCAPE_SUFFIX, true));
            }
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(content.substring(currentIndex));
        return result.toString();
    }
}

