/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.VelocityFilter;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component(value="radeoxmacros")
public class RadeoxMacrosFilter
extends AbstractFilter
implements Initializable {
    public static final Pattern SINGLE_LINE_MACRO_PATTERN = Pattern.compile("\\{(\\w+)(:(.+))?\\}");
    public static final Pattern MULTI_LINE_MACRO_PATTERN = Pattern.compile("\\{(\\w+)(:(.+?))?\\}(.+?)\\{\\1\\}", 32);
    @Requirement
    private ComponentManager componentManager;

    public void initialize() throws InitializationException {
        this.setPriority(100);
    }

    public String filter(String content, FilterContext filterContext) {
        content = this.filterMacros(content, SINGLE_LINE_MACRO_PATTERN, false, filterContext);
        content = this.filterMacros(content, MULTI_LINE_MACRO_PATTERN, true, filterContext);
        return content;
    }

    private String filterMacros(String content, Pattern pattern, boolean supportContent, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = pattern.matcher(content);
        int currentIndex = 0;
        RadeoxMacroConverter currentMacro = null;
        while (matcher.find()) {
            boolean multilines;
            Matcher velocityCloseMatcher;
            Matcher velocityOpenMatcher;
            String before = content.substring(currentIndex, matcher.start());
            if (currentMacro != null && !currentMacro.isInline()) {
                before = CleanUtil.setLeadingNewLines(before, 2);
            }
            String allcontent = matcher.group(0);
            String macroName = matcher.group(1);
            String params = matcher.group(3);
            String macroContent = matcher.groupCount() >= 4 ? matcher.group(4) : null;
            boolean velocityOpen = false;
            boolean velocityClose = false;
            if (params != null) {
                velocityOpenMatcher = VelocityFilter.VELOCITYOPEN_PATTERN.matcher(params);
                velocityOpen |= velocityOpenMatcher.find();
                params = velocityOpenMatcher.replaceAll("");
                velocityCloseMatcher = VelocityFilter.VELOCITYCLOSE_PATTERN.matcher(params);
                velocityClose |= velocityCloseMatcher.find();
                params = velocityCloseMatcher.replaceAll("");
            }
            if (macroContent != null) {
                velocityOpenMatcher = VelocityFilter.VELOCITYOPEN_PATTERN.matcher(macroContent);
                velocityOpen |= velocityOpenMatcher.find();
                macroContent = velocityOpenMatcher.replaceAll("");
                velocityCloseMatcher = VelocityFilter.VELOCITYCLOSE_PATTERN.matcher(macroContent);
                velocityClose |= velocityCloseMatcher.find();
                macroContent = velocityCloseMatcher.replaceAll("");
            }
            try {
                currentMacro = (RadeoxMacroConverter)this.componentManager.lookup(RadeoxMacroConverter.class, macroName);
                if (currentMacro.supportContent() == supportContent) {
                    before = CleanUtil.removeTrailingNewLines(before, 1, true);
                    if (!currentMacro.isInline()) {
                        before = CleanUtil.setTrailingNewLines(before, 2);
                    }
                    allcontent = currentMacro.convert(macroName, RadeoxMacrosFilter.getMacroParameters(currentMacro, params), macroContent, filterContext);
                    if (currentMacro.protectResult()) {
                        allcontent = filterContext.addProtectedContent(allcontent, currentMacro.isInline());
                    }
                } else {
                    currentMacro = null;
                }
            }
            catch (ComponentLookupException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Can't find macro converter [" + macroName + "]", (Throwable)e);
                }
                currentMacro = null;
            }
            result.append(before);
            boolean bl = multilines = allcontent.indexOf("\n") != -1;
            if (velocityOpen) {
                VelocityFilter.appendVelocityOpen(result, filterContext, multilines);
            }
            result.append(allcontent);
            if (velocityClose) {
                VelocityFilter.appendVelocityClose(result, filterContext, multilines);
            }
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        if (currentMacro != null && !currentMacro.isInline()) {
            result.append(CleanUtil.setLeadingNewLines(content.substring(currentIndex), 2));
        } else {
            result.append(content.substring(currentIndex));
        }
        return result.toString();
    }

    public static RadeoxMacroParameters getMacroParameters(RadeoxMacroConverter macroConverter, String parameters) {
        RadeoxMacroParameters parameterMap = new RadeoxMacroParameters();
        if (parameters != null) {
            String[] parameterTable = parameters.split("\\|");
            for (int parameterIndex = 0; parameterIndex < parameterTable.length; ++parameterIndex) {
                String parameterValue;
                String parameterName;
                String parameter = parameterTable[parameterIndex];
                int equalIndex = parameter.indexOf(61);
                int parameterType = macroConverter.getParameterType(parameterIndex);
                if (equalIndex >= 0) {
                    parameterName = parameter.substring(0, equalIndex);
                    parameterValue = parameter.substring(equalIndex + 1);
                } else {
                    parameterName = macroConverter.getParameterName(parameterIndex);
                    parameterValue = parameter;
                }
                if (parameterType != 0 && (parameterType & 2) != 0 && parameterValue.trim().length() == 0 || (parameterType & 1) != 0 && "none".equals(parameterValue)) {
                    parameterValue = null;
                }
                parameterMap.addParameter(parameterIndex, parameterName, parameterValue);
            }
        }
        return parameterMap;
    }
}

