/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.parser.xwiki10.VelocityFilter;
import org.xwiki.rendering.internal.parser.xwiki10.html.InvalidHtmlException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.HTMLElementConverter;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="htmlmacro")
@Singleton
public class HTMLFilter
extends AbstractFilter
implements Initializable {
    public static final String HTMLOPEN_SUFFIX = "htmlopen";
    public static final String HTMLCLOSE_SUFFIX = "htmlclose";
    public static final String HTMLOPEN_SPATTERN = "(?:" + FilterContext.XWIKI1020TOKEN_OP + "(?:XWIKI1020TOKENS)" + "htmlopen" + "\\d+" + FilterContext.XWIKI1020TOKEN_CP + ")";
    public static final String HTMLCLOSE_SPATTERN = "(?:" + FilterContext.XWIKI1020TOKEN_OP + "(?:XWIKI1020TOKENS)" + "htmlclose" + "\\d+" + FilterContext.XWIKI1020TOKEN_CP + ")";
    public static final String EMPTYLINEVELOCITY_SPATTERN = "((?:" + FilterContext.XWIKI1020TOKENI_PATTERN + ")|[^" + FilterContext.XWIKI1020TOKEN_CP + "])\n(" + VelocityFilter.NLGROUP_SPATTERN + ")\n" + "(" + FilterContext.XWIKI1020TOKENI_PATTERN + "|[^" + FilterContext.XWIKI1020TOKEN_OP + "]|$)";
    public static final Pattern EMPTYLINEVELOCITY_PATTERN = Pattern.compile(EMPTYLINEVELOCITY_SPATTERN);
    public static final Pattern LINEBREAK_PATTERN = Pattern.compile(Pattern.quote("\\\\"));
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="escape20")
    private Filter escape20SyntaxFilter;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        this.setPriority(3000);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        char[] array = content.toCharArray();
        HTMLFilterContext context = new HTMLFilterContext(filterContext);
        StringBuffer beforeHtmlBuffer = new StringBuffer();
        StringBuffer htmlBuffer = new StringBuffer();
        StringBuffer afterHtmlBuffer = new StringBuffer();
        boolean inHTMLMacro = false;
        int i = 0;
        while (i < array.length) {
            StringBuffer nonHtmlbuffer;
            char c = array[i];
            context.setConversion(false);
            context.pushType();
            context.setHTML(false);
            context.setVelocityOpen(false);
            context.setVelocityClose(false);
            context.setInline(true);
            StringBuffer stringBuffer = nonHtmlbuffer = inHTMLMacro ? afterHtmlBuffer : beforeHtmlBuffer;
            if (c == '<') {
                try {
                    String str;
                    StringBuffer buffer;
                    StringBuffer htmlBlock = new StringBuffer();
                    int start = i;
                    i = this.getHTMLBlock(array, i, null, htmlBlock, context);
                    if (context.isHTML()) {
                        if (!inHTMLMacro) {
                            inHTMLMacro = true;
                        } else {
                            htmlBuffer.append(afterHtmlBuffer);
                            afterHtmlBuffer.setLength(0);
                        }
                        buffer = htmlBuffer;
                        str = context.cleanContent(new String(array, start, i - start));
                    } else {
                        buffer = nonHtmlbuffer;
                        str = htmlBlock.toString();
                    }
                    if (context.isVelocityOpen()) {
                        VelocityFilter.appendVelocityOpen(buffer, filterContext, false);
                    }
                    if (context.isConversion() && !context.isInline() && (htmlBuffer.length() > 0 || buffer.length() > 0)) {
                        CleanUtil.setTrailingNewLines(buffer, 2);
                    }
                    buffer.append(str);
                    if (!context.isVelocityClose()) continue;
                    VelocityFilter.appendVelocityClose(buffer, filterContext, false);
                }
                catch (InvalidHtmlException e) {
                    this.logger.debug("Invalid HTML block at char [" + i + "]", (Throwable)e);
                    nonHtmlbuffer.append(c);
                    ++i;
                }
                continue;
            }
            nonHtmlbuffer.append(c);
            ++i;
        }
        String beforeHtmlContent = beforeHtmlBuffer.toString();
        String htmlContent = htmlBuffer.toString();
        String afterHtmlContent = afterHtmlBuffer.toString();
        if (htmlContent.length() > 0) {
            Matcher velocityAfterMatcher;
            Matcher velocityBeforeMatcher = VelocityFilter.VELOCITYOPEN_PATTERN.matcher(beforeHtmlBuffer);
            if (velocityBeforeMatcher.find()) {
                htmlContent = beforeHtmlContent.substring(velocityBeforeMatcher.start()) + htmlContent;
                beforeHtmlContent = beforeHtmlContent.substring(0, velocityBeforeMatcher.start());
            }
            if ((velocityAfterMatcher = VelocityFilter.VELOCITYCLOSE_PATTERN.matcher(afterHtmlContent)).find()) {
                htmlContent = htmlContent + afterHtmlContent.substring(0, velocityAfterMatcher.end());
                afterHtmlContent = afterHtmlContent.substring(velocityAfterMatcher.end());
            }
        } else {
            Matcher velocityContentMatcher = VelocityFilter.VELOCITYCONTENT_PATTERN.matcher(beforeHtmlBuffer);
            if (velocityContentMatcher.find()) {
                htmlContent = velocityContentMatcher.group(0);
                afterHtmlContent = beforeHtmlContent.substring(velocityContentMatcher.end());
                beforeHtmlContent = beforeHtmlContent.substring(0, velocityContentMatcher.start());
            }
        }
        if (htmlContent.length() > 0) {
            boolean multilines;
            boolean bl = multilines = filterContext.unProtect(htmlContent).indexOf("\n") != -1;
            if (multilines && htmlContent.indexOf("\n\n") != -1) {
                int beforeIndex = beforeHtmlContent.lastIndexOf("\n\n");
                if (beforeIndex == -1) {
                    htmlContent = beforeHtmlContent + htmlContent;
                    beforeHtmlContent = "";
                } else {
                    htmlContent = beforeHtmlContent.substring(beforeIndex + 2) + htmlContent;
                    beforeHtmlContent = beforeHtmlContent.substring(0, beforeIndex + 2);
                }
                int afterIndex = afterHtmlContent.indexOf("\n\n");
                if (afterIndex == -1) {
                    htmlContent = htmlContent + afterHtmlContent;
                    afterHtmlContent = "";
                } else {
                    htmlContent = htmlContent + afterHtmlContent.substring(0, afterIndex);
                    afterHtmlContent = afterHtmlContent.substring(afterIndex);
                }
            }
            Matcher velocityOpenMatcher = VelocityFilter.VELOCITYOPEN_PATTERN.matcher(htmlContent);
            boolean velocityOpen = velocityOpenMatcher.find();
            htmlContent = velocityOpenMatcher.replaceFirst("");
            Matcher velocityCloseMatcher = VelocityFilter.VELOCITYCLOSE_PATTERN.matcher(htmlContent);
            boolean velocityClose = velocityCloseMatcher.find();
            htmlContent = velocityCloseMatcher.replaceFirst("");
            htmlContent = this.forceEmptyLines(htmlContent);
            htmlContent = this.forceLineBreak(htmlContent);
            result.append(beforeHtmlContent);
            if (velocityOpen) {
                VelocityFilter.appendVelocityOpen(result, filterContext, multilines);
            }
            HTMLFilter.appendHTMLOpen(result, filterContext, multilines);
            result.append(filterContext.addProtectedContent(this.escape20SyntaxFilter.filter(htmlContent, filterContext), false));
            HTMLFilter.appendHTMLClose(result, filterContext, multilines);
            if (velocityClose) {
                VelocityFilter.appendVelocityClose(result, filterContext, multilines);
            }
            result.append(afterHtmlContent);
        } else {
            result = beforeHtmlBuffer;
        }
        return result.toString();
    }

    private String forceEmptyLines(String htmlContent) {
        return EMPTYLINEVELOCITY_PATTERN.matcher(htmlContent).replaceAll("$1\n$4<p/>\n$5");
    }

    private String forceLineBreak(String htmlContent) {
        return LINEBREAK_PATTERN.matcher(htmlContent).replaceAll("<br/>");
    }

    private int getHTMLBlock(char[] array, int currentIndex, StringBuffer elementName, StringBuffer htmlBlock, HTMLFilterContext context) throws InvalidHtmlException {
        int i = currentIndex + 1;
        context.setType(null);
        if (i < array.length) {
            i = array[i] == '/' ? this.getEndElement(array, currentIndex, elementName, htmlBlock, context) : (array[i] == '!' && i + 2 < array.length && array[i + 1] == '-' && array[i + 2] == '-' ? this.getComment(array, currentIndex, htmlBlock, context) : this.getElement(array, currentIndex, elementName, htmlBlock, context));
        }
        return i;
    }

    private int getComment(char[] array, int currentIndex, StringBuffer commentBlock, HTMLFilterContext context) {
        int i;
        context.setType(HTMLType.COMMENT);
        context.setHTML(true);
        for (i = currentIndex + 4; i < array.length && (array[i - 1] != '>' || array[i - 2] != '-' || array[i - 3] != '-'); ++i) {
        }
        commentBlock.append(array, currentIndex, i - currentIndex);
        return i;
    }

    private int getElement(char[] array, int currentIndex, StringBuffer elementNameBuffer, StringBuffer element, HTMLFilterContext context) throws InvalidHtmlException {
        String convertedElement;
        if (Character.isWhitespace(array[currentIndex + 1])) {
            throw new InvalidHtmlException();
        }
        StringBuffer beginElement = new StringBuffer();
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        if (elementNameBuffer == null) {
            elementNameBuffer = new StringBuffer();
        }
        int i = this.getBeginElement(array, currentIndex, elementNameBuffer, beginElement, parameterMap, context);
        String elementName = elementNameBuffer.toString();
        if (context.peekType() == HTMLType.BEGIN && "br".equals(elementName)) {
            context.setType(HTMLType.ELEMENT);
        }
        StringBuffer elementContent = null;
        if (context.peekType() == HTMLType.BEGIN) {
            elementContent = new StringBuffer();
            context.pushType();
            i = this.getElementContent(array, i, elementName, elementContent, null, context);
            context.popType();
        }
        if ((convertedElement = this.convertElement(elementName, elementContent != null ? elementContent.toString() : null, parameterMap, context)) != null) {
            element.append(convertedElement);
        } else {
            context.setHTML(true);
        }
        context.setType(HTMLType.ELEMENT);
        return i;
    }

    private String convertElement(String name, String content, Map<String, String> parameters, HTMLFilterContext context) {
        String convertedElement = null;
        context.setConversion(false);
        try {
            HTMLElementConverter currentMacro = (HTMLElementConverter)this.componentManager.lookup(HTMLElementConverter.class, name);
            convertedElement = currentMacro.convert(name, parameters, content, context);
            if (convertedElement != null) {
                context.setConversion(true);
                context.setInline(currentMacro.isInline());
            }
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Can't find macro converter [" + name + "]", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.debug("Failed to convert macro [" + name + "]", (Throwable)e);
        }
        return convertedElement;
    }

    private int getElementContent(char[] array, int currentIndex, String currentElement, StringBuffer elementContent, StringBuffer endElement, HTMLFilterContext context) {
        int i = currentIndex;
        while (i < array.length) {
            char c = array[i];
            context.setConversion(false);
            StringBuffer htmlBlock = new StringBuffer();
            if (c == '<') {
                try {
                    StringBuffer elementNameBuffer = new StringBuffer();
                    i = this.getHTMLBlock(array, i, elementNameBuffer, htmlBlock, context);
                    String elementName = elementNameBuffer.toString();
                    if (context.peekType() == HTMLType.END && (currentElement.equals(elementName) || currentElement.startsWith(elementName))) {
                        if (endElement == null) break;
                        endElement.append(htmlBlock);
                        break;
                    }
                    if (context.peekType() != null) {
                        elementContent.append(htmlBlock);
                        continue;
                    }
                    elementContent.append(c);
                    ++i;
                }
                catch (InvalidHtmlException e) {
                    this.logger.debug("Invalid HTML block at char [" + i + "]", (Throwable)e);
                    ++i;
                }
                continue;
            }
            elementContent.append(c);
            ++i;
        }
        return i;
    }

    private int getBeginElement(char[] array, int currentIndex, StringBuffer elementName, StringBuffer beginElement, Map<String, String> parameterMap, HTMLFilterContext context) throws InvalidHtmlException {
        int i = currentIndex + 1;
        if (i == array.length) {
            throw new InvalidHtmlException();
        }
        if (!Character.isLetter(array[i])) {
            throw new InvalidHtmlException();
        }
        i = this.getElementName(array, i, elementName, context);
        i = this.getWhiteSpaces(array, i, null);
        i = this.getElementParameters(array, i, null, parameterMap);
        if ((i = this.getWhiteSpaces(array, i, null)) == array.length) {
            context.setType(HTMLType.ELEMENT);
        } else if (array[i] == '/' && i + 1 < array.length && array[i + 1] == '>') {
            context.setType(HTMLType.ELEMENT);
            i += 2;
        } else {
            context.setType(HTMLType.BEGIN);
            ++i;
        }
        beginElement.append(array, currentIndex, i - currentIndex);
        return i;
    }

    private int getEndElement(char[] array, int currentIndex, StringBuffer elementName, StringBuffer endElement, HTMLFilterContext context) throws InvalidHtmlException {
        int i = currentIndex + 2;
        if (i == array.length || Character.isWhitespace(array[i])) {
            throw new InvalidHtmlException();
        }
        i = this.getElementName(array, i, elementName, context);
        if (array[i = this.getWhiteSpaces(array, i, null)] == '>') {
            ++i;
        }
        context.setType(HTMLType.END);
        if (endElement != null) {
            endElement.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    private int getElementName(char[] array, int currentIndex, StringBuffer elementName, HTMLFilterContext context) {
        int i;
        for (i = currentIndex; i < array.length && !Character.isWhitespace(array[i]); ++i) {
            if (array[i] == '>') {
                context.setType(HTMLType.BEGIN);
                break;
            }
            if (array[i] != '/' || i + 1 >= array.length || array[i + 1] != '>') continue;
            context.setType(HTMLType.END);
            break;
        }
        if (elementName != null) {
            elementName.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    private int getWhiteSpaces(char[] array, int currentIndex, StringBuffer htmlBlock) {
        int i;
        for (i = currentIndex; i < array.length && Character.isWhitespace(array[i]); ++i) {
        }
        if (htmlBlock != null) {
            htmlBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    private int getElementParameters(char[] array, int currentIndex, StringBuffer parametersBlock, Map<String, String> parameterMap) {
        int i = currentIndex;
        while (i < array.length) {
            if ((i = this.getWhiteSpaces(array, i, null)) >= array.length) continue;
            if (array[i] == '>' || array[i] == '/' && i + 1 < array.length && array[i + 1] == '>') break;
            i = this.getElementParameter(array, i, null, parameterMap);
        }
        if (parametersBlock != null) {
            parametersBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    private int getElementParameter(char[] array, int currentIndex, StringBuffer parameterBlock, Map<String, String> parameterMap) {
        int i;
        StringBuffer keyBlock = new StringBuffer();
        for (i = currentIndex; i < array.length && array[i] != '>' && array[i] != '=' && !Character.isWhitespace(array[i]); ++i) {
            keyBlock.append(array[i]);
        }
        if ((i = this.getWhiteSpaces(array, i, null)) < array.length && array[i] == '=') {
            ++i;
            i = this.getWhiteSpaces(array, i, null);
            StringBuffer valueBlock = new StringBuffer();
            i = this.getElementParameterValue(array, i, valueBlock);
            parameterMap.put(keyBlock.toString(), valueBlock.toString());
        }
        if (parameterBlock != null) {
            parameterBlock.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    private int getElementParameterValue(char[] array, int currentIndex, StringBuffer valueBlock) {
        int i = currentIndex;
        char escaped = '\u0000';
        if (array[i] == '\"' || array[i] == '\'') {
            escaped = array[i];
            ++i;
        }
        while (i < array.length && array[i] != '>') {
            if (escaped == '\u0000') {
                if (Character.isWhitespace(array[i])) {
                    break;
                }
            } else if (array[i] == escaped) {
                ++i;
                break;
            }
            ++i;
        }
        valueBlock.append(array, currentIndex, i - currentIndex);
        return i;
    }

    public static void appendHTMLOpen(StringBuffer result, FilterContext filterContext, boolean nl) {
        result.append(filterContext.addProtectedContent("{{html clean=\"false\" wiki=\"true\"}}" + (nl ? "\n" : ""), HTMLOPEN_SUFFIX, true));
    }

    public static void appendHTMLClose(StringBuffer result, FilterContext filterContext, boolean nl) {
        result.append(filterContext.addProtectedContent((nl ? "\n" : "") + "{{/html}}", HTMLCLOSE_SUFFIX, true));
    }

    static enum HTMLType {
        ELEMENT,
        BEGIN,
        END,
        COMMENT;

    }

    public static class HTMLFilterContext {
        private boolean conversion = false;
        private Stack<HTMLType> type = new Stack();
        private boolean html = false;
        private FilterContext filterContext;
        private boolean velocityOpen;
        private boolean velocityClose;
        private boolean inline;

        public HTMLFilterContext(FilterContext filterContext) {
            this.filterContext = filterContext;
        }

        public boolean isConversion() {
            return this.conversion;
        }

        public void setConversion(boolean conversion) {
            this.conversion = conversion;
        }

        public FilterContext getFilterContext() {
            return this.filterContext;
        }

        public HTMLType peekType() {
            return this.type.peek();
        }

        public void pushType() {
            this.type.push(null);
        }

        public HTMLType popType() {
            return this.type.pop();
        }

        public void setType(HTMLType type) {
            this.type.set(this.type.size() - 1, type);
        }

        public boolean isHTML() {
            return this.html;
        }

        public void setHTML(boolean isHTML) {
            this.html = isHTML;
        }

        public boolean isVelocityOpen() {
            return this.velocityOpen;
        }

        public void setVelocityOpen(boolean velocityOpen) {
            this.velocityOpen = velocityOpen;
        }

        public boolean isVelocityClose() {
            return this.velocityClose;
        }

        public void setVelocityClose(boolean velocityClose) {
            this.velocityClose = velocityClose;
        }

        public boolean isInline() {
            return this.inline;
        }

        public void setInline(boolean inline) {
            this.inline = inline;
        }

        public String cleanContent(String content) {
            Matcher velocityOpenMatcher = VelocityFilter.VELOCITYOPEN_PATTERN.matcher(content);
            this.setVelocityOpen(this.isVelocityOpen() | velocityOpenMatcher.find());
            String cleanedContent = velocityOpenMatcher.replaceFirst("");
            Matcher velocityCloseMatcher = VelocityFilter.VELOCITYCLOSE_PATTERN.matcher(cleanedContent);
            this.setVelocityClose(this.isVelocityClose() | velocityCloseMatcher.find());
            cleanedContent = velocityCloseMatcher.replaceFirst("");
            return cleanedContent;
        }
    }
}

