/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="hr")
@Singleton
public class HrFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern HR_PATTERN = Pattern.compile("(?<=^| )----++(?=$| )", 8);

    public void initialize() throws InitializationException {
        this.setPriority(800);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        String hr20 = filterContext.addProtectedContent("----", false);
        Matcher matcher = HR_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            String before = content.substring(currentIndex, matcher.start());
            if (currentIndex > 0) {
                before = CleanUtil.setLeadingNewLines(before, 2);
            }
            result.append(before);
            result.append(hr20);
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(CleanUtil.setLeadingNewLines(content.substring(currentIndex), 2));
        return result.toString();
    }
}

