/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10.macro;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.AbstractRadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;

@Component
@Named(value="style")
@Singleton
public class StyleRadeoxMacroConverter
extends AbstractRadeoxMacroConverter {
    public StyleRadeoxMacroConverter() {
        this.registerParameter("type");
        this.registerParameter("id", 3);
        this.registerParameter("class", 3);
        this.registerParameter("align", 3);
        this.registerParameter("name", 3);
        this.registerParameter("font-size", 3);
        this.registerParameter("font-family", 3);
        this.registerParameter("color", 3);
        this.registerParameter("background-color", 3);
        this.registerParameter("float", 3);
        this.registerParameter("width", 3);
        this.registerParameter("height", 3);
        this.registerParameter("border", 3);
        this.registerParameter("document");
        this.registerParameter("icon", 3);
    }

    @Override
    public String convert(String name, RadeoxMacroParameters parameters, String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        boolean inline = parameters.get("type") != null && ((RadeoxMacroParameter)parameters.get("type")).getValue().equals("span");
        StringBuffer parametersOpen = new StringBuffer();
        Map<String, String> styleParameters = this.convertParameters(parameters);
        if (styleParameters.size() > 0) {
            parametersOpen.append("(% ");
            this.appendParameters(parametersOpen, styleParameters);
            parametersOpen.append(" %)");
            result.append(filterContext.addProtectedContent(parametersOpen.toString(), inline));
        }
        if (!inline) {
            result.append(filterContext.addProtectedContent("(((", false));
        }
        result.append(this.convertContent(content.trim(), parameters, filterContext));
        if (inline) {
            result.append(filterContext.addProtectedContent("(%%)", true));
        } else {
            result.append(filterContext.addProtectedContent(")))", false));
        }
        return result.toString();
    }

    @Override
    protected String convertContent(String content, RadeoxMacroParameters parameters, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        this.appendIcon(result, parameters, filterContext);
        if (content.length() > 0) {
            result.append(' ');
        }
        result.append(content);
        return result.toString();
    }

    @Override
    protected Map<String, String> convertParameters(RadeoxMacroParameters parameters) {
        LinkedHashMap<String, String> boxParameters = new LinkedHashMap<String, String>();
        RadeoxMacroParameter classes = (RadeoxMacroParameter)parameters.get("class");
        RadeoxMacroParameter icon = (RadeoxMacroParameter)parameters.get("icon");
        RadeoxMacroParameter id = (RadeoxMacroParameter)parameters.get("id");
        RadeoxMacroParameter align = (RadeoxMacroParameter)parameters.get("align");
        RadeoxMacroParameter name = (RadeoxMacroParameter)parameters.get("name");
        RadeoxMacroParameter size = (RadeoxMacroParameter)parameters.get("font-size");
        RadeoxMacroParameter font = (RadeoxMacroParameter)parameters.get("font-family");
        RadeoxMacroParameter color = (RadeoxMacroParameter)parameters.get("color");
        RadeoxMacroParameter bgcolor = (RadeoxMacroParameter)parameters.get("background-color");
        RadeoxMacroParameter fl = (RadeoxMacroParameter)parameters.get("float");
        RadeoxMacroParameter width = (RadeoxMacroParameter)parameters.get("width");
        RadeoxMacroParameter height = (RadeoxMacroParameter)parameters.get("height");
        RadeoxMacroParameter border = (RadeoxMacroParameter)parameters.get("border");
        if (classes != null) {
            boxParameters.put("class", classes.getValue().trim());
        } else if (icon != null) {
            boxParameters.put("class", "stylemacro");
        }
        if (id != null) {
            boxParameters.put("id", id.getValue().trim());
        }
        if (name != null) {
            boxParameters.put("name", name.getValue().trim());
        }
        if (align != null) {
            boxParameters.put("align", align.getValue().trim());
        }
        StringBuffer styleStr = new StringBuffer();
        if (size != null) {
            styleStr.append("font-size:" + size.getValue().trim() + "; ");
        }
        if (font != null) {
            styleStr.append("font-family:" + font.getValue().trim() + "; ");
        }
        if (color != null) {
            styleStr.append("color:" + color.getValue().trim() + "; ");
        }
        if (bgcolor != null) {
            styleStr.append("background-color:" + bgcolor.getValue().trim() + "; ");
        }
        if (width != null) {
            styleStr.append("width:" + width.getValue().trim() + "; ");
        }
        if (fl != null) {
            styleStr.append("float:" + fl.getValue().trim() + "; ");
        }
        if (height != null) {
            styleStr.append("height:" + height.getValue().trim() + "; ");
        }
        if (border != null) {
            styleStr.append("border:" + border.getValue().trim() + "; ");
        }
        if (styleStr.length() > 0) {
            boxParameters.put("style", styleStr.toString());
        }
        return boxParameters;
    }

    private void appendIcon(StringBuffer result, RadeoxMacroParameters parameters, FilterContext filterContext) {
        RadeoxMacroParameter document = (RadeoxMacroParameter)parameters.get("document");
        RadeoxMacroParameter icon = (RadeoxMacroParameter)parameters.get("icon");
        boolean hasIcon = false;
        if (document != null && document.getValue().contains("=")) {
            document = null;
        }
        if (icon != null) {
            hasIcon = true;
        }
        if (hasIcon) {
            result.append(filterContext.addProtectedContent("image:", true));
            if (document != null) {
                result.append(document + "@" + icon);
            } else {
                result.append(icon.getValue().trim());
            }
        }
    }

    @Override
    public boolean protectResult() {
        return false;
    }

    @Override
    public boolean supportContent() {
        return true;
    }
}

