/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.parser.xwiki10.macro;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroConverter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameter;
import org.xwiki.rendering.parser.xwiki10.macro.RadeoxMacroParameters;

public abstract class AbstractRadeoxMacroConverter
implements RadeoxMacroConverter {
    private String name;
    private List<Object[]> parametersNames = new ArrayList<Object[]>();

    protected AbstractRadeoxMacroConverter() {
    }

    protected AbstractRadeoxMacroConverter(String name) {
        this.name = name;
    }

    @Override
    public String getParameterName(int parameterIndex) {
        return this.getParameterName(this.parametersNames.get(parameterIndex));
    }

    @Override
    public int getParameterType(int parameterIndex) {
        return this.getParameterType(this.parametersNames.get(parameterIndex));
    }

    private String getParameterName(Object[] objects) {
        return objects == null ? null : (String)objects[0];
    }

    private int getParameterType(Object[] objects) {
        return objects == null ? 0 : (Integer)objects[1];
    }

    protected void registerParameter(String parameterName) {
        this.registerParameter(parameterName, 0);
    }

    protected void registerParameter(String parameterName, int paramType) {
        this.parametersNames.add(new Object[]{parameterName, paramType});
    }

    @Override
    public boolean protectResult() {
        return true;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    protected String convertName(String name) {
        return this.name == null ? name : this.name;
    }

    protected Map<String, String> convertParameters(RadeoxMacroParameters parameters) {
        LinkedHashMap<String, String> parameters20 = new LinkedHashMap<String, String>(parameters.size());
        for (RadeoxMacroParameter radeoxParameter : parameters.values()) {
            this.convertParameter(parameters20, radeoxParameter);
        }
        return parameters20;
    }

    protected void convertParameter(Map<String, String> parameters20, RadeoxMacroParameter radeoxParameter) {
        this.convertParameter(parameters20, radeoxParameter.getName(), radeoxParameter.getValue());
    }

    protected void convertParameter(Map<String, String> parameters20, String key, String value) {
        parameters20.put(key, value);
    }

    protected String convertContent(String content, RadeoxMacroParameters parameters, FilterContext filterContext) {
        return content;
    }

    @Override
    public String convert(String name, RadeoxMacroParameters parameters, String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        result.append("{{");
        result.append(this.convertName(name));
        if (parameters.size() > 0) {
            result.append(' ');
            this.appendParameters(result, this.convertParameters(parameters));
        }
        if (content != null) {
            result.append("}}");
            String macroContent = this.convertContent(content, parameters, filterContext);
            if (macroContent.indexOf("\n") != -1) {
                result.append("\n" + macroContent + "\n");
            } else {
                result.append(macroContent);
            }
            result.append("{{/");
            result.append(this.convertName(name));
        } else {
            result.append("/");
        }
        result.append("}}");
        return result.toString();
    }

    protected void appendParameters(StringBuffer result, Map<String, String> parameters) {
        StringBuffer parametersSB = new StringBuffer();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (parametersSB.length() > 0) {
                parametersSB.append(" ");
            }
            parametersSB.append(parameter.getKey());
            parametersSB.append("=");
            parametersSB.append("\"" + parameter.getValue() + "\"");
        }
        result.append(parametersSB);
    }
}

