/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.Filter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;
import org.xwiki.rendering.parser.xwiki10.util.CleanUtil;

@Component
@Named(value="link")
@Singleton
public class LinkSyntaxFilter
extends AbstractFilter
implements Initializable {
    private static final Pattern LINKSYNTAX_PATTERN = Pattern.compile("\\[(.+?)\\]");
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("^[a-zA-Z0-9+.-]*://.*$");
    @Inject
    @Named(value="escape20")
    private Filter escape20Filter;

    public void initialize() throws InitializationException {
        this.setPriority(900);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = LINKSYNTAX_PATTERN.matcher(content);
        int current = 0;
        while (matcher.find()) {
            String before = content.substring(current, matcher.start());
            result.append(CleanUtil.removeTrailingNewLines(before, 1, true));
            StringBuffer linkResult = new StringBuffer();
            linkResult.append("[[");
            String str = matcher.group(1);
            if (str != null) {
                str = str.trim();
                String text = null;
                String href = null;
                String target = null;
                int pipeIndex = str.indexOf(124);
                int pipeLength = 1;
                if (pipeIndex == -1) {
                    pipeIndex = str.indexOf(62);
                }
                if (pipeIndex == -1) {
                    pipeIndex = str.indexOf("&gt;");
                    pipeLength = 4;
                }
                if (-1 != pipeIndex) {
                    text = str.substring(0, pipeIndex).trim();
                    str = str.substring(pipeIndex + pipeLength);
                }
                pipeIndex = str.indexOf(124);
                pipeLength = 1;
                if (pipeIndex == -1) {
                    pipeIndex = str.indexOf(62);
                }
                if (pipeIndex == -1) {
                    pipeIndex = str.indexOf("&gt;");
                    pipeLength = 4;
                }
                if (-1 != pipeIndex) {
                    target = str.substring(pipeIndex + pipeLength).trim();
                    str = str.substring(0, pipeIndex);
                }
                href = str.trim();
                if (text != null) {
                    linkResult.append(this.escape20Filter.filter(text, filterContext).replace("~", "~~").replace(">>", "~>~>").replace("||", "~|~|"));
                    linkResult.append(">>");
                }
                if (!URL_SCHEME_PATTERN.matcher(href).matches()) {
                    int queryStringIndex;
                    int anchorIndex = href.lastIndexOf(35);
                    if (anchorIndex == -1) {
                        anchorIndex = href.length();
                    }
                    if ((queryStringIndex = href.lastIndexOf(63, anchorIndex - 1)) == -1) {
                        queryStringIndex = anchorIndex;
                    }
                    String anchor = href.substring(anchorIndex);
                    String queryString = href.substring(queryStringIndex, anchorIndex);
                    href = href.substring(0, queryStringIndex);
                    linkResult.append(href);
                    linkResult.append(anchor);
                    linkResult.append(queryString);
                } else {
                    linkResult.append(href);
                }
                if (target != null) {
                    linkResult.append("||target=");
                    linkResult.append(target);
                }
            }
            linkResult.append("]]");
            result.append(CleanUtil.extractVelocity(linkResult, filterContext, true, true));
            current = matcher.end();
        }
        if (current == 0) {
            return content;
        }
        result.append(content.substring(current));
        return result.toString();
    }
}

