/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki10;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.parser.xwiki10.AbstractFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;

@Component
@Named(value="escape20")
@Singleton
public class Escape20SyntaxFilter
extends AbstractFilter
implements Initializable {
    private static final String LISTSYNTAX_SPATTERN = Pattern.quote("*") + "|" + Pattern.quote(":") + "|" + Pattern.quote(";") + "|" + Pattern.quote("1.");
    private static final String CELLSYNTAX_SPATTERN = Pattern.quote("|=") + "|" + Pattern.quote("!=") + "|" + Pattern.quote("!!") + "|" + Pattern.quote("|");
    private static final String FORMATSYNTAX_SPATTERN = Pattern.quote("//") + "|" + Pattern.quote("**") + "|" + Pattern.quote("__") + "|" + Pattern.quote("--") + "|" + Pattern.quote("^^") + "|" + Pattern.quote(",,") + "|" + Pattern.quote("##");
    private static final String NEWLINESYNTAX_CONTENT_SPATTERN = LISTSYNTAX_SPATTERN + "|" + Pattern.quote("=");
    private static final String NEWLINESYNTAX_SPATTERN = "^( *)((?:" + NEWLINESYNTAX_CONTENT_SPATTERN + "))";
    private static final String INLINESYNTAX_PATTERN = FORMATSYNTAX_SPATTERN + "|" + CELLSYNTAX_SPATTERN + "|" + Pattern.quote("~") + "|" + Pattern.quote("{{") + "|" + Pattern.quote("}}") + "|" + Pattern.quote("(((") + "|" + Pattern.quote(")))");
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("(" + NEWLINESYNTAX_SPATTERN + ")|(" + INLINESYNTAX_PATTERN + ")", 8);

    public void initialize() throws InitializationException {
        this.setPriority(10000);
    }

    @Override
    public String filter(String content, FilterContext filterContext) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = SYNTAX_PATTERN.matcher(content);
        int currentIndex = 0;
        while (matcher.find()) {
            result.append(content.substring(currentIndex, matcher.start()));
            if (matcher.group(1) != null) {
                result.append(matcher.group(2) + "~" + matcher.group(3));
            } else {
                result.append("~" + matcher.group(4));
            }
            currentIndex = matcher.end();
        }
        if (currentIndex == 0) {
            return content;
        }
        result.append(content.substring(currentIndex));
        return result.toString();
    }
}

