/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.parser.xwiki10.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.internal.parser.xwiki10.VelocityFilter;
import org.xwiki.rendering.parser.xwiki10.FilterContext;

public final class CleanUtil {
    private static final Pattern STARTING_NL_GROUP_PATTERN = Pattern.compile("^\\n*");
    private static final Pattern STARTING_NLNOOUTPUT_GROUP_PATTERN = Pattern.compile("^" + VelocityFilter.NLGROUP_SPATTERN);
    private static final Pattern ENDING_NL_GROUP_PATTERN = Pattern.compile("\\n*$");
    private static final Pattern ENDING_NLNOOUTPUT_GROUP_PATTERN = Pattern.compile(VelocityFilter.NLGROUP_SPATTERN + "$");
    private static final Pattern HTMLSPACEORNEWLINE_PATTERN = Pattern.compile("[\\s\\n]");
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([^\\\\])\\\\\\\\|([^\\\\])\\\\");

    private CleanUtil() {
    }

    public static String cleanSpacesAndNewLines(String content) {
        return HTMLSPACEORNEWLINE_PATTERN.matcher(content).replaceAll(" ");
    }

    public static String removeLeadingNewLines(String content, int nb, boolean replaceWithSpace) {
        int foundNb;
        String cleanedContent = content;
        Matcher matcher = STARTING_NL_GROUP_PATTERN.matcher(content);
        int n = foundNb = matcher.find() ? matcher.end() - matcher.start() : 0;
        if (foundNb > 0 && foundNb <= nb) {
            cleanedContent = content.substring(foundNb > nb ? nb : foundNb);
            if (replaceWithSpace) {
                cleanedContent = " " + cleanedContent;
            }
        }
        return cleanedContent;
    }

    public static String removeTrailingNewLines(String content, int nb, boolean replaceWithSpace) {
        int foundNb;
        String cleanedContent = content;
        Matcher matcher = ENDING_NL_GROUP_PATTERN.matcher(content);
        int n = foundNb = matcher.find() ? matcher.end() - matcher.start() : 0;
        if (foundNb > 0 && foundNb <= nb) {
            cleanedContent = content.substring(0, content.length() - (foundNb > nb ? nb : foundNb));
            if (replaceWithSpace) {
                cleanedContent = cleanedContent + " ";
            }
        }
        return cleanedContent;
    }

    public static String setLeadingNewLines(String content, int nb) {
        int foundNb;
        String cleanedContent = content;
        Matcher matcher = STARTING_NLNOOUTPUT_GROUP_PATTERN.matcher(content);
        int n = foundNb = matcher.find() ? StringUtils.countMatches((CharSequence)matcher.group(0), (CharSequence)"\n") : 0;
        if (foundNb < nb) {
            cleanedContent = StringUtils.repeat((String)"\n", (int)(nb - foundNb)) + content;
        }
        return cleanedContent;
    }

    public static String setTrailingNewLines(String content, int nb) {
        int foundNb;
        String cleanedContent = content;
        Matcher matcher = ENDING_NLNOOUTPUT_GROUP_PATTERN.matcher(content);
        int n = foundNb = matcher.find() ? StringUtils.countMatches((CharSequence)matcher.group(0), (CharSequence)"\n") : 0;
        if (foundNb < nb) {
            cleanedContent = content + StringUtils.repeat((String)"\n", (int)(nb - foundNb));
        }
        return cleanedContent;
    }

    public static void setTrailingNewLines(StringBuffer content, int nb) {
        int foundNb;
        Matcher matcher = ENDING_NLNOOUTPUT_GROUP_PATTERN.matcher(content);
        int n = foundNb = matcher.find() ? StringUtils.countMatches((CharSequence)matcher.group(0), (CharSequence)"\n") : 0;
        if (foundNb < nb) {
            content.append(StringUtils.repeat((String)"\n", (int)(nb - foundNb)));
        }
    }

    public static String removeLeadingNewLines(String content) {
        return STARTING_NL_GROUP_PATTERN.matcher(content).replaceAll("");
    }

    public static String removeTrailingNewLines(String content) {
        return ENDING_NL_GROUP_PATTERN.matcher(content).replaceAll("");
    }

    public static String convertEscape(String content) {
        return ESCAPE_PATTERN.matcher(content).replaceAll("$1~");
    }

    public static String extractVelocity(CharSequence content, FilterContext filterContext) {
        return CleanUtil.extractVelocity(content, filterContext, false, false);
    }

    public static String extractVelocity(CharSequence content, FilterContext filterContext, boolean protect, boolean inline) {
        boolean multilines;
        String cleanedContent = content.toString();
        Matcher velocityOpenMatcher = VelocityFilter.VELOCITYOPEN_PATTERN.matcher(cleanedContent);
        boolean velocityOpen = velocityOpenMatcher.find();
        cleanedContent = velocityOpenMatcher.replaceFirst("");
        Matcher velocityCloseMatcher = VelocityFilter.VELOCITYCLOSE_PATTERN.matcher(cleanedContent);
        boolean velocityClose = velocityCloseMatcher.find();
        cleanedContent = velocityCloseMatcher.replaceFirst("");
        StringBuffer buffer = new StringBuffer();
        boolean bl = multilines = filterContext.unProtect(cleanedContent).indexOf("\n") != -1;
        if (velocityOpen) {
            VelocityFilter.appendVelocityOpen(buffer, filterContext, multilines);
        }
        if (protect) {
            buffer.append(filterContext.addProtectedContent(cleanedContent, inline));
        } else {
            buffer.append(cleanedContent);
        }
        if (velocityClose) {
            VelocityFilter.appendVelocityClose(buffer, filterContext, multilines);
        }
        return buffer.toString();
    }
}

