/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxEscapeWikiPrinter;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxListenerChain;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxMacroRenderer;
import org.xwiki.rendering.internal.renderer.xwiki20.reference.XWikiSyntaxResourceRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.StackableChainingListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.VoidWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;

public class XWikiSyntaxChainingRenderer
extends AbstractChainingPrintRenderer
implements StackableChainingListener {
    private XWikiSyntaxResourceRenderer linkResourceRenderer;
    private XWikiSyntaxResourceRenderer imageResourceRenderer;
    private XWikiSyntaxMacroRenderer macroPrinter;
    private ResourceReferenceSerializer linkReferenceSerializer;
    private ResourceReferenceSerializer imageReferenceSerializer;
    private boolean isFirstElementRendered = false;
    private StringBuffer listStyle = new StringBuffer();
    private Map<String, String> previousFormatParameters;

    public XWikiSyntaxChainingRenderer(ListenerChain listenerChain, ResourceReferenceSerializer linkReferenceSerializer, ResourceReferenceSerializer imageReferenceSerializer) {
        this.setListenerChain(listenerChain);
        this.linkReferenceSerializer = linkReferenceSerializer;
        this.imageReferenceSerializer = imageReferenceSerializer;
        this.linkResourceRenderer = this.createXWikiSyntaxLinkRenderer(this.getListenerChain(), linkReferenceSerializer);
        this.imageResourceRenderer = this.createXWikiSyntaxImageRenderer(this.getListenerChain(), imageReferenceSerializer);
        this.macroPrinter = new XWikiSyntaxMacroRenderer();
    }

    protected XWikiSyntaxResourceRenderer createXWikiSyntaxLinkRenderer(ListenerChain listenerChain, ResourceReferenceSerializer linkReferenceSerializer) {
        return new XWikiSyntaxResourceRenderer((XWikiSyntaxListenerChain)listenerChain, linkReferenceSerializer);
    }

    protected XWikiSyntaxResourceRenderer createXWikiSyntaxImageRenderer(ListenerChain listenerChain, ResourceReferenceSerializer imageReferenceSerializer) {
        return new XWikiSyntaxResourceRenderer((XWikiSyntaxListenerChain)listenerChain, imageReferenceSerializer);
    }

    private BlockStateChainingListener getBlockState() {
        return this.getXWikiSyntaxListenerChain().getBlockStateChainingListener();
    }

    public StackableChainingListener createChainingListenerInstance() {
        XWikiSyntaxChainingRenderer renderer = new XWikiSyntaxChainingRenderer(this.getListenerChain(), this.linkReferenceSerializer, this.imageReferenceSerializer);
        renderer.setPrinter(this.getPrinter());
        return renderer;
    }

    private XWikiSyntaxListenerChain getXWikiSyntaxListenerChain() {
        return (XWikiSyntaxListenerChain)this.getListenerChain();
    }

    private XWikiSyntaxResourceRenderer getLinkRenderer() {
        return this.linkResourceRenderer;
    }

    private XWikiSyntaxResourceRenderer getImageRenderer() {
        return this.imageResourceRenderer;
    }

    private XWikiSyntaxMacroRenderer getMacroPrinter() {
        return this.macroPrinter;
    }

    public void beginGroup(Map<String, String> parameters) {
        if (!this.getBlockState().isInLine()) {
            this.printEmptyLine();
        }
        if (parameters.size() > 0) {
            this.printParameters(parameters, true);
        }
        this.print("(((");
        this.print("\n");
        this.getListenerChain().pushAllStackableListeners();
    }

    public void endDocument(MetaData metaData) {
        this.getXWikiPrinter().flush();
    }

    public void endGroup(Map<String, String> parameters) {
        this.print("\n");
        this.print(")))");
        this.getListenerChain().popAllStackableListeners();
    }

    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getXWikiPrinter().setBeforeLink(true);
        if (this.getLinkRenderer().forceFullSyntax(this.getXWikiPrinter(), isFreeStandingURI, parameters) && this.getXWikiPrinter().getBuffer().length() > 0 && this.getXWikiPrinter().getBuffer().charAt(this.getXWikiPrinter().getBuffer().length() - 1) == '[') {
            this.getXWikiPrinter().setEscapeLastChar(true);
        }
        this.getXWikiPrinter().flush();
        this.getXWikiPrinter().setBeforeLink(false);
        int linkDepth = this.getBlockState().getLinkDepth();
        if (linkDepth < 2) {
            this.getLinkRenderer().beginRenderLink(this.getXWikiPrinter(), reference, isFreeStandingURI, parameters);
            XWikiSyntaxEscapeWikiPrinter linkLabelPrinter = new XWikiSyntaxEscapeWikiPrinter((WikiPrinter)new DefaultWikiPrinter(), this.getXWikiSyntaxListenerChain());
            linkLabelPrinter.setOnNewLine(this.getXWikiPrinter().isOnNewLine());
            this.pushPrinter((WikiPrinter)linkLabelPrinter);
        } else if (isFreeStandingURI) {
            this.print(this.getLinkRenderer().serialize(reference, isFreeStandingURI));
        }
    }

    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (this.getBlockState().getLinkDepth() == 1) {
            XWikiSyntaxEscapeWikiPrinter linkBlocksPrinter = this.getXWikiPrinter();
            linkBlocksPrinter.flush();
            String content = linkBlocksPrinter.toString();
            this.popPrinter();
            this.getLinkRenderer().renderLinkContent(this.getXWikiPrinter(), content);
            this.getLinkRenderer().endRenderLink(this.getXWikiPrinter(), reference, isFreeStandingURI, parameters);
        }
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        if (this.previousFormatParameters != null) {
            if (!parameters.isEmpty()) {
                if (!((Object)this.previousFormatParameters).equals(parameters)) {
                    this.previousFormatParameters = null;
                    this.printParameters(parameters, false);
                } else {
                    this.previousFormatParameters = null;
                }
            }
        } else if (this.previousFormatParameters == null) {
            this.printParameters(parameters, false);
        }
        switch (format) {
            case BOLD: {
                if (this.previousFormatParameters != null) {
                    this.getPrinter().print("(%%)");
                    this.previousFormatParameters = null;
                }
                this.getXWikiPrinter().printBeginBold();
                break;
            }
            case ITALIC: {
                if (this.previousFormatParameters != null) {
                    this.getPrinter().print("(%%)");
                    this.previousFormatParameters = null;
                }
                this.getXWikiPrinter().printBeginItalic();
                break;
            }
            case STRIKEDOUT: {
                this.print("--");
                break;
            }
            case UNDERLINED: {
                this.print("__");
                break;
            }
            case SUPERSCRIPT: {
                this.print("^^");
                break;
            }
            case SUBSCRIPT: {
                this.print(",,");
                break;
            }
            case MONOSPACE: {
                this.print("##");
                break;
            }
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.print("**");
                break;
            }
            case ITALIC: {
                this.getXWikiPrinter().printEndItalic();
                break;
            }
            case STRIKEDOUT: {
                this.print("--");
                break;
            }
            case UNDERLINED: {
                this.print("__");
                break;
            }
            case SUPERSCRIPT: {
                this.print("^^");
                break;
            }
            case SUBSCRIPT: {
                this.print(",,");
                break;
            }
            case MONOSPACE: {
                this.print("##");
                break;
            }
        }
        if (!parameters.isEmpty()) {
            this.previousFormatParameters = parameters;
        }
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
    }

    public void endParagraph(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void onNewLine() {
        if (this.getBlockState().isInLine()) {
            if (this.getXWikiSyntaxListenerChain().getConsecutiveNewLineStateChainingListener().getNewLineCount() > 1) {
                this.print("\\\\");
            } else if (this.getXWikiSyntaxListenerChain().getLookaheadChainingListener().getNextEvent().eventType.isInlineEnd()) {
                this.print("\\\\");
            } else {
                this.print("\n");
            }
        } else {
            this.print("\n");
        }
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
        if (!isInline) {
            this.printEmptyLine();
            this.print(this.getMacroPrinter().renderMacro(id, parameters, content, isInline));
        } else {
            this.getXWikiPrinter().printInlineMacro(this.getMacroPrinter().renderMacro(id, parameters, content, isInline));
        }
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
        this.print(StringUtils.repeat((String)"=", (int)level.getAsInt()) + " ");
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.print(" " + StringUtils.repeat((String)"=", (int)level.getAsInt()));
    }

    public void onWord(String word) {
        this.printDelayed(word);
    }

    public void onSpace() {
        this.printDelayed(" ");
    }

    public void onSpecialSymbol(char symbol) {
        this.printDelayed("" + symbol);
    }

    public void beginList(ListType listType, Map<String, String> parameters) {
        if (this.getBlockState().getListDepth() == 1) {
            this.printEmptyLine();
        } else {
            this.getPrinter().print("\n");
        }
        if (listType == ListType.BULLETED) {
            this.listStyle.append("*");
        } else {
            this.listStyle.append("1");
        }
        this.printParameters(parameters);
    }

    public void beginListItem() {
        if (this.getBlockState().getListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        this.print(this.listStyle.toString());
        if (StringUtils.contains((String)this.listStyle.toString(), (char)'1')) {
            this.print(".");
        }
        this.print(" ");
    }

    public void endList(ListType listType, Map<String, String> parameters) {
        this.listStyle.setLength(this.listStyle.length() - 1);
        this.getXWikiPrinter().flush();
    }

    public void endListItem() {
        this.previousFormatParameters = null;
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        if (!isInline) {
            this.printEmptyLine();
        }
        this.pushPrinter((WikiPrinter)new XWikiSyntaxEscapeWikiPrinter((WikiPrinter)VoidWikiPrinter.VOIDWIKIPRINTER, this.getXWikiSyntaxListenerChain()));
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.previousFormatParameters = null;
        this.popPrinter();
        this.print(this.getMacroPrinter().renderMacro(name, parameters, content, isInline));
    }

    public void onId(String name) {
        this.print("{{id name=\"" + name + "\"/}}");
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.printEmptyLine();
        this.printParameters(parameters);
        this.print("----");
    }

    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        if (!isInline) {
            this.printEmptyLine();
        }
        this.printParameters(parameters);
        this.print("{{{");
        this.getXWikiPrinter().printVerbatimContent(protectedString);
        this.print("}}}");
    }

    public void onEmptyLines(int count) {
        this.print(StringUtils.repeat((String)"\n", (int)count));
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        if (this.getBlockState().getDefinitionListDepth() == 1 && !this.getBlockState().isInList()) {
            this.printEmptyLine();
        } else {
            this.print("\n");
        }
        this.printParameters(parameters);
    }

    public void beginDefinitionTerm() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        if (this.listStyle.length() > 0) {
            this.print(this.listStyle.toString());
            if (this.listStyle.charAt(0) == '1') {
                this.print(".");
            }
        }
        this.print(StringUtils.repeat((String)":", (int)(this.getBlockState().getDefinitionListDepth() - 1)));
        this.print("; ");
    }

    public void beginDefinitionDescription() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print("\n");
        }
        if (this.listStyle.length() > 0) {
            this.print(this.listStyle.toString());
            if (this.listStyle.charAt(0) == '1') {
                this.print(".");
            }
        }
        this.print(StringUtils.repeat((String)":", (int)(this.getBlockState().getDefinitionListDepth() - 1)));
        this.print(": ");
    }

    public void endDefinitionDescription() {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void endDefinitionTerm() {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void beginQuotation(Map<String, String> parameters) {
        if (!this.getBlockState().isInQuotationLine()) {
            this.printEmptyLine();
        }
        if (!parameters.isEmpty()) {
            this.printParameters(parameters);
        }
    }

    public void beginQuotationLine() {
        if (this.getBlockState().getQuotationLineIndex() > 0) {
            this.getPrinter().print("\n");
        }
        this.print(StringUtils.repeat((String)">", (int)this.getBlockState().getQuotationDepth()));
    }

    public void endQuotationLine() {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void beginTable(Map<String, String> parameters) {
        this.printEmptyLine();
        if (!parameters.isEmpty()) {
            this.printParameters(parameters);
        }
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.print("|");
        this.printParameters(parameters, false);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.print("|=");
        this.printParameters(parameters, false);
    }

    public void beginTableRow(Map<String, String> parameters) {
        if (this.getBlockState().getCellRow() > 0) {
            this.print("\n");
        }
        this.printParameters(parameters, false);
    }

    public void endTableCell(Map<String, String> parameters) {
        this.previousFormatParameters = null;
        this.getXWikiPrinter().flush();
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.previousFormatParameters = null;
    }

    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getImageRenderer().beginRenderLink(this.getXWikiPrinter(), reference, isFreeStandingURI, parameters);
        this.getImageRenderer().endRenderLink(this.getXWikiPrinter(), reference, isFreeStandingURI, parameters);
    }

    protected void printParameters(Map<String, String> parameters) {
        this.printParameters(parameters, true);
    }

    protected void printParameters(Map<String, String> parameters, boolean newLine) {
        StringBuffer parametersStr = new StringBuffer();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (key == null || value == null) continue;
            value = value.replaceAll("[~\"]", "~$0");
            value = value.replace("%)", "~%)");
            parametersStr.append(' ').append(key).append('=').append('\"').append(value).append('\"');
        }
        if (parametersStr.length() > 0) {
            StringBuffer buffer = new StringBuffer("(%");
            buffer.append(parametersStr);
            buffer.append(" %)");
            if (newLine) {
                buffer.append("\n");
            }
            this.print(buffer.toString());
        }
    }

    private void printDelayed(String text) {
        this.print(text, true);
    }

    private void print(String text) {
        this.print(text, false);
    }

    private void print(String text, boolean isDelayed) {
        if (this.previousFormatParameters != null) {
            this.getPrinter().print("(%%)");
            this.previousFormatParameters = null;
        }
        if (isDelayed) {
            this.getXWikiPrinter().printDelayed(text);
        } else {
            this.getPrinter().print(text);
        }
    }

    private void printEmptyLine() {
        if (this.isFirstElementRendered) {
            this.print("\n\n");
        } else {
            this.isFirstElementRendered = true;
        }
    }

    public void setPrinter(WikiPrinter printer) {
        if (printer instanceof XWikiSyntaxEscapeWikiPrinter) {
            super.setPrinter(printer);
        } else {
            super.setPrinter((WikiPrinter)new XWikiSyntaxEscapeWikiPrinter(printer, (XWikiSyntaxListenerChain)this.getListenerChain()));
        }
    }

    public XWikiSyntaxEscapeWikiPrinter getXWikiPrinter() {
        return (XWikiSyntaxEscapeWikiPrinter)super.getPrinter();
    }

    protected void popPrinter() {
        this.getXWikiPrinter().flush();
        super.popPrinter();
    }
}

