/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20.reference;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.ResourceReferenceSerializer;
import org.xwiki.rendering.renderer.reference.ResourceReferenceTypeSerializer;

@Component
@Named(value="xwiki/2.0/link")
@Singleton
public class XWikiSyntaxLinkReferenceSerializer
implements ResourceReferenceSerializer {
    private static final String COMPONENT_PREFIX = "xwiki/2.0";
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="xwiki/2.0")
    private ResourceReferenceTypeSerializer defaultResourceReferenceTypeSerializer;

    public String serialize(ResourceReference reference) {
        String result;
        try {
            result = ((ResourceReferenceTypeSerializer)this.componentManager.lookup(ResourceReferenceTypeSerializer.class, this.getLinkTypeSerializerComponentPrefix() + "/" + reference.getType().getScheme())).serialize(reference);
        }
        catch (ComponentLookupException e) {
            try {
                result = ((ResourceReferenceTypeSerializer)this.componentManager.lookup(ResourceReferenceTypeSerializer.class, this.getLinkTypeSerializerComponentPrefix())).serialize(reference);
            }
            catch (ComponentLookupException e2) {
                result = this.defaultResourceReferenceTypeSerializer.serialize(reference);
            }
        }
        return result;
    }

    protected String getLinkTypeSerializerComponentPrefix() {
        return COMPONENT_PREFIX;
    }
}

