/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20.reference;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.ResourceReferenceTypeSerializer;

@Component
@Named(value="xwiki/2.0/interwiki")
@Singleton
public class InterWikiReferenceTypeSerializer
implements ResourceReferenceTypeSerializer {
    private static final String[] ESCAPE_REPLACEMENTS_REFERENCE = new String[]{String.valueOf('\\') + '\\'};
    private static final String[] ESCAPES_REFERENCE = new String[]{String.valueOf('\\')};
    private static final String[] ESCAPE_REPLACEMENTS_EXTRA = new String[]{String.valueOf('\\') + "@", String.valueOf('\\') + '\\'};
    private static final String[] ESCAPES_EXTRA = new String[]{"@", String.valueOf('\\')};

    public String serialize(ResourceReference reference) {
        String interWikiAlias = reference.getParameter("interWikiAlias");
        String result = this.addEscapesToReferencePart(reference.getReference());
        if (interWikiAlias != null) {
            result = this.addEscapesToReferencePart(reference.getReference()) + "@" + this.addEscapesToExtraParts(interWikiAlias);
        }
        return result;
    }

    protected String addEscapesToReferencePart(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_REFERENCE, (String[])ESCAPE_REPLACEMENTS_REFERENCE);
    }

    protected String addEscapesToExtraParts(String text) {
        return StringUtils.replaceEach((String)text, (String[])ESCAPES_EXTRA, (String[])ESCAPE_REPLACEMENTS_EXTRA);
    }
}

