/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xwiki20;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.internal.renderer.xwiki20.XWikiSyntaxListenerChain;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;

public class XWikiSyntaxEscapeHandler {
    public static final Pattern STARLISTEND_PATTERN = Pattern.compile("(\\**([:;]*|1+\\.)?\\p{Blank})");
    private static final Pattern LIST_PATTERN = Pattern.compile("\\p{Blank}*((\\*+[:;]*)|([1*]+\\.[:;]*)|([:;]+))\\p{Blank}+");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(\\>+)");
    private static final Pattern HEADER_PATTERN = Pattern.compile("\\p{Blank}*(=+)");
    private static final Pattern TABLE_PATTERN = Pattern.compile("\\p{Blank}*(\\||!!)");
    private static final Pattern DOUBLE_CHARS_PATTERN = Pattern.compile("\\/\\/|\\*\\*|__|--|\\^\\^|,,|##|\\\\\\\\");
    public static final String ESCAPE_CHAR = "~";
    private boolean beforeLink = false;
    private boolean onNewLine = true;

    public void setOnNewLine(boolean onNewLine) {
        this.onNewLine = onNewLine;
    }

    public boolean isOnNewLine() {
        return this.onNewLine;
    }

    public void escape(StringBuffer accumulatedBuffer, XWikiSyntaxListenerChain listenerChain, boolean escapeLastChar, Pattern escapeFirstIfMatching) {
        BlockStateChainingListener blockStateListener = listenerChain.getBlockStateChainingListener();
        this.replaceAll(accumulatedBuffer, ESCAPE_CHAR, "~~");
        this.replaceAll(accumulatedBuffer, "(%", "~(%");
        if (blockStateListener.isInLine() && this.isOnNewLine()) {
            this.escapeFirstMatchedCharacter(LIST_PATTERN, accumulatedBuffer);
            this.escapeFirstMatchedCharacter(HEADER_PATTERN, accumulatedBuffer);
            this.escapeFirstMatchedCharacter(TABLE_PATTERN, accumulatedBuffer);
            this.escapeFirstMatchedCharacter(QUOTE_PATTERN, accumulatedBuffer);
        }
        if (blockStateListener.isInTable()) {
            this.replaceAll(accumulatedBuffer, "|", "~|");
            this.replaceAll(accumulatedBuffer, "!!", "~!!");
        }
        if (escapeFirstIfMatching != null) {
            this.escapeFirstMatchedCharacter(escapeFirstIfMatching, accumulatedBuffer);
        }
        if (blockStateListener.isInHeader()) {
            this.replaceAll(accumulatedBuffer, "=", "~=");
        }
        this.replaceAll(accumulatedBuffer, "{{{", "~{~{~{");
        this.replaceAll(accumulatedBuffer, "{{", "~{~{");
        this.replaceAll(accumulatedBuffer, "(((", "~(~(~(");
        this.replaceAll(accumulatedBuffer, ")))", "~)~)~)");
        Matcher matcher = DOUBLE_CHARS_PATTERN.matcher(accumulatedBuffer.toString());
        int i = 0;
        while (matcher.find()) {
            accumulatedBuffer.replace(matcher.start() + i, matcher.end() + i, ESCAPE_CHAR + matcher.group().charAt(0) + ESCAPE_CHAR + matcher.group().charAt(1));
            i += 2;
        }
        this.escapeURI(accumulatedBuffer, "image:");
        this.escapeURI(accumulatedBuffer, "attach:");
        this.escapeURI(accumulatedBuffer, "mailto:");
        if (escapeLastChar) {
            accumulatedBuffer.insert(accumulatedBuffer.length() - 1, '~');
        }
        this.replaceAll(accumulatedBuffer, "[[", "~[~[");
        int linkLevel = this.getLinkLevel(listenerChain);
        if (linkLevel > 0) {
            String escape = StringUtils.repeat((String)ESCAPE_CHAR, (int)linkLevel);
            this.replaceAll(accumulatedBuffer, ESCAPE_CHAR, escape + ESCAPE_CHAR);
            this.replaceAll(accumulatedBuffer, "]]", escape + "]" + escape + "]");
            this.replaceAll(accumulatedBuffer, ">>", escape + ">" + escape + ">");
            this.replaceAll(accumulatedBuffer, "||", escape + "|" + escape + "|");
        }
    }

    private int getLinkLevel(XWikiSyntaxListenerChain listenerChain) {
        int linkDepth = listenerChain.getBlockStateChainingListener().getLinkDepth();
        if (this.beforeLink) {
            --linkDepth;
        }
        return linkDepth;
    }

    public void setBeforeLink(boolean beforeLink) {
        this.beforeLink = beforeLink;
    }

    private void escapeURI(StringBuffer accumulatedBuffer, String match) {
        int pos = accumulatedBuffer.indexOf(match);
        if (pos > -1) {
            accumulatedBuffer.insert(pos + match.length() - 1, '~');
        }
    }

    private void replaceAll(StringBuffer accumulatedBuffer, String match, String replacement) {
        int pos = -replacement.length();
        while (pos + replacement.length() < accumulatedBuffer.length() && (pos = accumulatedBuffer.indexOf(match, pos + replacement.length())) != -1) {
            accumulatedBuffer.replace(pos, pos + match.length(), replacement);
        }
    }

    private void escapeFirstMatchedCharacter(Pattern pattern, StringBuffer accumulatedBuffer) {
        Matcher matcher = pattern.matcher(accumulatedBuffer);
        if (matcher.lookingAt()) {
            accumulatedBuffer.replace(matcher.start(1), matcher.start(1) + 1, ESCAPE_CHAR + matcher.group(1).charAt(0));
        }
    }
}

