/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xwiki20;

import java.lang.reflect.Type;
import javax.inject.Provider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.rendering.internal.parser.reference.type.AttachmentResourceReferenceTypeParser;
import org.xwiki.rendering.internal.parser.reference.type.URLResourceReferenceTypeParser;
import org.xwiki.rendering.internal.parser.xwiki20.XWiki20ImageReferenceParser;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.test.annotation.BeforeComponent;
import org.xwiki.test.annotation.ComponentList;
import org.xwiki.test.mockito.MockitoComponentManagerRule;

@ComponentList(value={XWiki20ImageReferenceParser.class, URLResourceReferenceTypeParser.class, AttachmentResourceReferenceTypeParser.class})
public class XWiki20ImageReferenceParserTest {
    @Rule
    public MockitoComponentManagerRule componentManager = new MockitoComponentManagerRule();
    private ResourceReferenceParser parser;

    @BeforeComponent
    public void setUpComponents() throws Exception {
        this.componentManager.registerMockComponent(WikiModel.class);
        Provider contextComponentManagerProvider = (Provider)this.componentManager.registerMockComponent((Type)new DefaultParameterizedType(null, Provider.class, new Type[]{ComponentManager.class}), "context");
        Mockito.when((Object)contextComponentManagerProvider.get()).thenReturn((Object)this.componentManager);
    }

    @Before
    public void setUp() throws Exception {
        this.parser = (ResourceReferenceParser)this.componentManager.getInstance(ResourceReferenceParser.class, "xwiki/2.0/image");
    }

    @Test
    public void testParseImagesCommon() throws Exception {
        ResourceReference reference = this.parser.parse("wiki:space.page@filename");
        Assert.assertEquals((Object)ResourceType.ATTACHMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"wiki:space.page@filename", (Object)reference.getReference());
        Assert.assertEquals((Object)"Typed = [false] Type = [attach] Reference = [wiki:space.page@filename]", (Object)reference.toString());
        Assert.assertFalse((boolean)reference.isTyped());
        reference = this.parser.parse("http://server/path/to/image");
        Assert.assertEquals((Object)ResourceType.URL, (Object)reference.getType());
        Assert.assertEquals((Object)"http://server/path/to/image", (Object)reference.getReference());
        Assert.assertEquals((Object)"Typed = [false] Type = [url] Reference = [http://server/path/to/image]", (Object)reference.toString());
        Assert.assertFalse((boolean)reference.isTyped());
    }

    @Test
    public void testParseImages() throws Exception {
        ResourceReference reference = this.parser.parse("attach:wiki:space.page@filename");
        Assert.assertEquals((Object)ResourceType.ATTACHMENT, (Object)reference.getType());
        Assert.assertEquals((Object)"attach:wiki:space.page@filename", (Object)reference.getReference());
        Assert.assertFalse((boolean)reference.isTyped());
        Assert.assertEquals((Object)"Typed = [false] Type = [attach] Reference = [attach:wiki:space.page@filename]", (Object)reference.toString());
    }
}

