/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.integration;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.test.integration.SyntaxWrappingListener;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationManager;
import org.xwiki.test.MockConfigurationSource;

public class RenderingTest {
    private String input;
    private String expected;
    private String parserId;
    private String targetSyntaxId;
    private boolean streaming;
    private boolean runTransformations;
    private Map<String, ?> configuration;
    private ComponentManager componentManager;

    public RenderingTest(String input, String expected, String parserId, String targetSyntaxId, boolean streaming, boolean runTransformations, Map<String, ?> configuration, ComponentManager componentManager) {
        this.input = input;
        this.expected = expected;
        this.parserId = parserId;
        this.targetSyntaxId = targetSyntaxId;
        this.streaming = streaming;
        this.runTransformations = runTransformations;
        this.configuration = configuration;
        this.componentManager = componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void execute() throws Throwable {
        MockConfigurationSource mockConfigurationSource;
        ConfigurationSource configurationSource;
        HashMap<String, Object> originalConfiguration = new HashMap<String, Object>();
        if (this.configuration != null && (configurationSource = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
            mockConfigurationSource = (MockConfigurationSource)configurationSource;
            for (Map.Entry<String, ?> entry : this.configuration.entrySet()) {
                originalConfiguration.put(entry.getKey(), mockConfigurationSource.getProperty(entry.getKey()));
                mockConfigurationSource.setProperty(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.runTestInternal();
        }
        catch (Throwable throwable) {
            ConfigurationSource configurationSource2;
            if (this.configuration != null && (configurationSource2 = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
                MockConfigurationSource mockConfigurationSource2 = (MockConfigurationSource)configurationSource2;
                for (Map.Entry entry : originalConfiguration.entrySet()) {
                    if (entry.getValue() == null) {
                        mockConfigurationSource2.removeProperty((String)entry.getKey());
                        continue;
                    }
                    mockConfigurationSource2.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
            throw throwable;
        }
        if (this.configuration != null && (configurationSource = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
            mockConfigurationSource = (MockConfigurationSource)configurationSource;
            for (Map.Entry<String, Object> entry : originalConfiguration.entrySet()) {
                if (entry.getValue() == null) {
                    mockConfigurationSource.removeProperty(entry.getKey());
                    continue;
                }
                mockConfigurationSource.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private void runTestInternal() throws Throwable {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        if (!this.streaming) {
            Parser parser = (Parser)this.getComponentManager().getInstance(Parser.class, this.parserId);
            XDOM xdom = parser.parse((Reader)new StringReader(this.input));
            if (this.runTransformations) {
                SyntaxFactory syntaxFactory = (SyntaxFactory)this.getComponentManager().getInstance(SyntaxFactory.class);
                TransformationManager transformationManager = (TransformationManager)this.getComponentManager().getInstance(TransformationManager.class);
                TransformationContext txContext = new TransformationContext(xdom, syntaxFactory.createSyntaxFromIdString(this.parserId));
                transformationManager.performTransformations((Block)xdom, txContext);
            }
            BlockRenderer renderer = (BlockRenderer)this.getComponentManager().getInstance(BlockRenderer.class, this.targetSyntaxId);
            HashMap metadataMap = new HashMap(xdom.getMetaData().getMetaData());
            metadataMap.remove("syntax");
            xdom = new XDOM(xdom.getChildren(), new MetaData(metadataMap));
            renderer.render((Block)xdom, (WikiPrinter)printer);
        } else {
            StreamParser parser = (StreamParser)this.getComponentManager().getInstance(StreamParser.class, this.parserId);
            PrintRendererFactory printRendererFactory = (PrintRendererFactory)this.getComponentManager().getInstance(PrintRendererFactory.class, this.targetSyntaxId);
            SyntaxWrappingListener listener = new SyntaxWrappingListener();
            listener.setWrappedListener((Listener)printRendererFactory.createRenderer((WikiPrinter)printer));
            parser.parse((Reader)new StringReader(this.input), (Listener)listener);
        }
        this.assertExpectedResult(this.expected, printer.toString());
    }

    private void assertExpectedResult(String expected, String result) {
        StringBuilder builder = new StringBuilder();
        this.normalizeExpectedValue(builder, expected);
        Pattern pattern = Pattern.compile(builder.toString(), 32);
        Matcher matcher = pattern.matcher(result);
        if (!matcher.matches()) {
            throw new ComparisonFailure("", expected, result);
        }
    }

    private void normalizeExpectedValue(StringBuilder builder, String expected) {
        int pos = expected.indexOf("${{{regex:");
        if (pos > -1) {
            builder.append(Pattern.quote(expected.substring(0, pos)));
            int pos2 = expected.indexOf("}}}", pos + 10);
            if (pos2 == -1) {
                throw new RuntimeException("Invalid regex declaration: missing closing part }}}");
            }
            builder.append(expected.substring(pos + 10, pos2));
            this.normalizeExpectedValue(builder, expected.substring(pos2 + 3));
        } else {
            builder.append(Pattern.quote(expected));
        }
    }

    public ComponentManager getComponentManager() throws Exception {
        return this.componentManager;
    }
}

