/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.test.cts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.test.cts.IgnoredRenderingTestClassRunner;
import org.xwiki.rendering.test.cts.RenderingTest;
import org.xwiki.rendering.test.cts.RenderingTestClassRunner;
import org.xwiki.rendering.test.cts.Scope;
import org.xwiki.rendering.test.cts.Syntax;
import org.xwiki.rendering.test.cts.TestData;
import org.xwiki.rendering.test.cts.TestDataParser;
import org.xwiki.test.jmock.XWikiComponentInitializer;

public class CompatibilityTestSuite
extends Suite {
    private static final TestDataParser PARSER = new TestDataParser();
    private final Object testInstance;
    private final ComponentManager componentManager;
    private final List<Runner> runners = new ArrayList<Runner>();

    public CompatibilityTestSuite(Class<?> klass) throws Exception {
        super(RenderingTest.class, Collections.emptyList());
        Syntax syntaxAnnotation;
        try {
            this.testInstance = klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to construct instance of [%s]", klass.getName()), e);
        }
        Scope scopeAnnotation = klass.getAnnotation(Scope.class);
        String packageFilter = "";
        String pattern = ".*\\.xml";
        if (scopeAnnotation != null) {
            packageFilter = scopeAnnotation.value();
            pattern = scopeAnnotation.pattern();
        }
        if ((syntaxAnnotation = klass.getAnnotation(Syntax.class)) == null) {
            throw new RuntimeException("You must specify a Syntax using the @Syntax annotation");
        }
        String syntaxId = syntaxAnnotation.value();
        String metadataSyntaxId = syntaxAnnotation.metadata();
        if (StringUtils.isEmpty((CharSequence)metadataSyntaxId)) {
            metadataSyntaxId = syntaxId;
        }
        this.componentManager = new XWikiComponentInitializer().getComponentManager();
        List<TestData> testDatas = PARSER.parseTestData(syntaxId, "cts", packageFilter, pattern);
        for (TestData testData : testDatas) {
            if (!this.isApplicable(testData)) continue;
            if (testData.syntaxData != null && !testData.isFailingTest()) {
                this.runners.add((Runner)new RenderingTestClassRunner(this.testInstance, this.getTestClass().getJavaClass(), testData, metadataSyntaxId));
                continue;
            }
            this.runners.add((Runner)new IgnoredRenderingTestClassRunner(this.getTestClass().getJavaClass(), testData));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public Description getDescription() {
        return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
    }

    private boolean isApplicable(TestData testData) {
        boolean isApplicable = testData.isNotApplicable() ? false : (testData.syntaxData == null ? this.hasParserOrRenderer(testData) : this.hasParserOrRenderer(testData));
        return isApplicable;
    }

    private boolean hasParserOrRenderer(TestData testData) {
        return testData.isSyntaxInputTest && this.hasParserForSyntax(testData.syntaxId) || !testData.isSyntaxInputTest && this.hasRendererForSyntax(testData.syntaxId);
    }

    private boolean hasParserForSyntax(String syntaxId) {
        boolean hasParser = true;
        try {
            this.componentManager.getInstance(Parser.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            hasParser = false;
        }
        return hasParser;
    }

    private boolean hasRendererForSyntax(String syntaxId) {
        boolean hasRenderer = true;
        try {
            this.componentManager.getInstance(BlockRenderer.class, syntaxId);
        }
        catch (ComponentLookupException e) {
            hasRenderer = false;
        }
        return hasRenderer;
    }
}

