/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.transformation.linkchecker.HTTPChecker;

@Component
@Singleton
public class DefaultHTTPChecker
implements HTTPChecker {
    @Inject
    private Logger logger;

    @Override
    public int check(String url) {
        int responseCode;
        HttpClient client = new HttpClient();
        try {
            GetMethod method = new GetMethod(url);
            method.getParams().setCookiePolicy("ignoreCookies");
            responseCode = client.executeMethod((HttpMethod)method);
            this.logger.debug("Result of pinging [{}]: code = [{}]", (Object)url, (Object)responseCode);
        }
        catch (Exception e) {
            responseCode = 0;
            this.logger.debug("Error while checking [{}]", (Object)url, (Object)e);
        }
        return responseCode;
    }
}

