/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerTransformationConfiguration;

@Component
@Singleton
public class DefaultLinkCheckerTransformationConfiguration
implements LinkCheckerTransformationConfiguration {
    private static final String PREFIX = "rendering.transformation.linkchecker.";
    private static final long TIMEOUT = 3600000L;
    private Long checkTimeout;
    @Inject
    private ComponentManager componentManager;

    @Override
    public long getCheckTimeout() {
        long result;
        if (this.checkTimeout != null) {
            result = this.checkTimeout;
        } else {
            try {
                ConfigurationSource source = (ConfigurationSource)this.componentManager.lookup(ConfigurationSource.class);
                result = (Long)source.getProperty("rendering.transformation.linkchecker.timeout", (Object)3600000L);
            }
            catch (ComponentLookupException e) {
                result = 3600000L;
            }
        }
        return result;
    }

    @Override
    public void setCheckTimeout(long checkTimeout) {
        this.checkTimeout = checkTimeout;
    }
}

