/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.transformation.linkchecker.HTTPChecker;

@Component
@Singleton
public class DefaultHTTPChecker
implements HTTPChecker,
Initializable {
    @Inject
    private Logger logger;
    private HttpClient httpClient;

    public void initialize() throws InitializationException {
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpClient.getParams().setParameter("http.useragent", (Object)"XWikiLinkChecker");
        this.httpClient.getParams().setCookiePolicy("ignoreCookies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int check(String url) {
        int responseCode;
        GetMethod method = new GetMethod(url);
        try {
            responseCode = this.httpClient.executeMethod((HttpMethod)method);
            this.logger.debug("Result of pinging [{}]: code = [{}]", (Object)url, (Object)responseCode);
        }
        catch (Exception e) {
            responseCode = 0;
            this.logger.debug("Error while checking [{}]", (Object)url, (Object)e);
        }
        finally {
            method.releaseConnection();
        }
        return responseCode;
    }
}

