/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.internal.transformation.linkchecker.HTTPChecker;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkQueueItem;
import org.xwiki.rendering.transformation.linkchecker.InvalidURLEvent;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerThreadInitializer;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerTransformationConfiguration;
import org.xwiki.rendering.transformation.linkchecker.LinkState;
import org.xwiki.rendering.transformation.linkchecker.LinkStateManager;

public class LinkCheckerThread
extends Thread {
    private ComponentManager componentManager;
    private LinkStateManager linkStateManager;
    private long timeout;
    private HTTPChecker httpChecker;
    private Queue<LinkQueueItem> linkQueue;
    private volatile boolean shouldStop;

    public LinkCheckerThread(ComponentManager componentManager, Queue<LinkQueueItem> linkQueue) throws InitializationException {
        try {
            this.linkStateManager = (LinkStateManager)componentManager.getInstance(LinkStateManager.class);
            this.httpChecker = (HTTPChecker)componentManager.getInstance(HTTPChecker.class);
            LinkCheckerTransformationConfiguration configuration = (LinkCheckerTransformationConfiguration)componentManager.getInstance(LinkCheckerTransformationConfiguration.class);
            this.timeout = configuration.getCheckTimeout();
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to initialize the Link Checker Thread. External link states won't be checked.", (Throwable)e);
        }
        this.linkQueue = linkQueue;
        this.componentManager = componentManager;
    }

    @Override
    public void run() {
        try {
            List initializers = this.componentManager.getInstanceList(LinkCheckerThreadInitializer.class);
            for (LinkCheckerThreadInitializer initializer : initializers) {
                initializer.initialize();
            }
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to initialize Link Checker Thread", e);
        }
        while (!this.shouldStop) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                break;
            }
            this.processLinkQueue();
        }
    }

    public void stopProcessing() {
        this.shouldStop = true;
        this.interrupt();
    }

    private void processLinkQueue() {
        LinkQueueItem queueItem = null;
        boolean shouldBeChecked = false;
        while (!this.linkQueue.isEmpty() && !shouldBeChecked) {
            LinkState state;
            queueItem = this.linkQueue.poll();
            shouldBeChecked = true;
            Map<String, LinkState> contentReferences = this.linkStateManager.getLinkStates().get(queueItem.getLinkReference());
            if (contentReferences == null || (state = contentReferences.get(queueItem.getContentReference())) == null || System.currentTimeMillis() - state.getLastCheckedTime() > this.timeout) continue;
            shouldBeChecked = false;
        }
        if (queueItem != null) {
            this.checkLink(queueItem);
        }
    }

    private void checkLink(LinkQueueItem queueItem) {
        int responseCode = this.httpChecker.check(queueItem.getLinkReference());
        Map<String, LinkState> contentReferences = this.linkStateManager.getLinkStates().get(queueItem.getLinkReference());
        if (contentReferences == null) {
            contentReferences = new ConcurrentHashMap<String, LinkState>();
        }
        LinkState state = new LinkState(responseCode, System.currentTimeMillis(), queueItem.getContextData());
        contentReferences.put(queueItem.getContentReference(), state);
        this.linkStateManager.getLinkStates().put(queueItem.getLinkReference(), contentReferences);
        if (responseCode < 200 || responseCode > 299) {
            HashMap<String, Object> eventSource = new HashMap<String, Object>();
            eventSource.put("url", queueItem.getLinkReference());
            eventSource.put("source", queueItem.getContentReference());
            eventSource.put("state", state);
            this.sendEvent(queueItem.getLinkReference(), eventSource);
        }
    }

    private void sendEvent(String url, Map<String, Object> source) {
        try {
            ObservationManager observationManager = (ObservationManager)this.componentManager.getInstance(ObservationManager.class);
            observationManager.notify((Event)new InvalidURLEvent(url), source);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }
}

