/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkCheckerThread;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkQueueItem;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;
import org.xwiki.rendering.transformation.linkchecker.LinkContextDataProvider;

@Component
@Named(value="linkchecker")
@Singleton
public class LinkCheckerTransformation
extends AbstractTransformation
implements Initializable {
    @Inject
    private ComponentManager componentManager;
    private Queue<LinkQueueItem> linkQueue = new ConcurrentLinkedQueue<LinkQueueItem>();
    private LinkCheckerThread checkerThread;

    public void initialize() throws InitializationException {
        this.checkerThread = new LinkCheckerThread(this.componentManager, this.linkQueue);
        this.checkerThread.setName("Link Checker Thread");
        this.checkerThread.start();
    }

    public void transform(Block source, TransformationContext context) throws TransformationException {
        for (LinkBlock linkBlock : source.getBlocks((BlockMatcher)new ClassBlockMatcher(LinkBlock.class), Block.Axes.DESCENDANT)) {
            if (!linkBlock.getReference().getType().equals((Object)ResourceType.URL)) continue;
            String linkReference = linkBlock.getReference().getReference();
            String contentReference = this.extractSourceContentReference((Block)linkBlock);
            if (contentReference == null) {
                contentReference = "default";
            }
            Map<String, Object> linkContextData = this.createLinkContextData(linkReference, contentReference);
            this.linkQueue.add(new LinkQueueItem(linkReference, contentReference, linkContextData));
        }
    }

    public void stopLinkCheckerThread() throws InterruptedException {
        this.checkerThread.stopProcessing();
        this.checkerThread.join();
    }

    private Map<String, Object> createLinkContextData(String linkReference, String contentReference) {
        LinkedHashMap<String, Object> linkContextData = null;
        try {
            List linkContextDataProviders = this.componentManager.getInstanceList(LinkContextDataProvider.class);
            for (LinkContextDataProvider linkContextDataProvider : linkContextDataProviders) {
                Map<String, Object> contextData = linkContextDataProvider.getContextData(linkReference, contentReference);
                if (linkContextData == null) {
                    linkContextData = new LinkedHashMap<String, Object>(contextData.size());
                }
                linkContextData.putAll(contextData);
            }
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to look up [" + LinkContextDataProvider.class.getName() + "] components", e);
        }
        return linkContextData;
    }

    private String extractSourceContentReference(Block source) {
        String contentSource = null;
        MetaDataBlock metaDataBlock = (MetaDataBlock)source.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null) {
            contentSource = (String)metaDataBlock.getMetaData().getMetaData("source");
        }
        return contentSource;
    }
}

