/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.internal.transformation.linkchecker.HTTPChecker;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkCheckerThread;
import org.xwiki.rendering.internal.transformation.linkchecker.LinkQueueItem;
import org.xwiki.rendering.transformation.linkchecker.InvalidURLEvent;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerThreadInitializer;
import org.xwiki.rendering.transformation.linkchecker.LinkCheckerTransformationConfiguration;
import org.xwiki.rendering.transformation.linkchecker.LinkState;
import org.xwiki.rendering.transformation.linkchecker.LinkStateManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultLinkCheckerThread
extends Thread
implements LinkCheckerThread {
    @Inject
    private Logger logger;
    @Inject
    private Provider<List<LinkCheckerThreadInitializer>> linkCheckerThreadInitializersProvider;
    @Inject
    private LinkStateManager linkStateManager;
    @Inject
    private Provider<ObservationManager> observationManagerProvider;
    @Inject
    private HTTPChecker httpChecker;
    @Inject
    private LinkCheckerTransformationConfiguration configuration;
    private Queue<LinkQueueItem> linkQueue;
    private volatile boolean shouldStop;

    @Override
    public void startProcessing(Queue<LinkQueueItem> linkQueue) {
        this.linkQueue = linkQueue;
        this.start();
    }

    @Override
    public void run(Queue<LinkQueueItem> linkQueue) {
        this.linkQueue = linkQueue;
        this.run();
    }

    @Override
    public void run() {
        for (LinkCheckerThreadInitializer initializer : (List)this.linkCheckerThreadInitializersProvider.get()) {
            initializer.initialize();
        }
        do {
            try {
                this.processLinkQueue();
                Thread.sleep(300L);
            }
            catch (Exception e) {
                this.logger.error("Link checker Thread was stopped due to some problem", (Throwable)e);
                break;
            }
        } while (!this.shouldStop);
    }

    @Override
    public void stopProcessing() {
        this.shouldStop = true;
        this.interrupt();
    }

    protected void processLinkQueue() {
        long timeout = this.configuration.getCheckTimeout();
        List<Pattern> excludedReferencePatterns = this.configuration.getExcludedReferencePatterns();
        LinkQueueItem queueItem = null;
        boolean shouldBeChecked = false;
        while (!this.linkQueue.isEmpty() && !shouldBeChecked && (shouldBeChecked = this.isExcluded((queueItem = this.linkQueue.poll()).getContentReference(), excludedReferencePatterns))) {
            LinkState state;
            Map<String, LinkState> contentReferences = this.linkStateManager.getLinkStates().get(queueItem.getLinkReference());
            if (contentReferences == null || (state = contentReferences.get(queueItem.getContentReference())) == null || System.currentTimeMillis() - state.getLastCheckedTime() > timeout) continue;
            shouldBeChecked = false;
        }
        if (shouldBeChecked && queueItem != null) {
            this.checkLink(queueItem);
        }
    }

    private boolean isExcluded(String contentReference, List<Pattern> excludedReferencePatterns) {
        for (Pattern pattern : excludedReferencePatterns) {
            Matcher matcher = pattern.matcher(contentReference);
            if (!matcher.matches()) continue;
            return false;
        }
        return true;
    }

    private void checkLink(LinkQueueItem queueItem) {
        int responseCode = this.httpChecker.check(queueItem.getLinkReference());
        Map<String, LinkState> contentReferences = this.linkStateManager.getLinkStates().get(queueItem.getLinkReference());
        if (contentReferences == null) {
            contentReferences = new ConcurrentHashMap<String, LinkState>();
        }
        LinkState state = new LinkState(responseCode, System.currentTimeMillis(), queueItem.getContextData());
        contentReferences.put(queueItem.getContentReference(), state);
        this.linkStateManager.getLinkStates().put(queueItem.getLinkReference(), contentReferences);
        if (responseCode < 200 || responseCode > 299) {
            HashMap<String, Object> eventSource = new HashMap<String, Object>();
            eventSource.put("url", queueItem.getLinkReference());
            eventSource.put("source", queueItem.getContentReference());
            eventSource.put("state", state);
            eventSource.put("contextData", queueItem.getContextData());
            this.sendEvent(queueItem.getLinkReference(), eventSource);
        }
    }

    private void sendEvent(String url, Map<String, Object> source) {
        ObservationManager observationManager = (ObservationManager)this.observationManagerProvider.get();
        if (observationManager != null) {
            observationManager.notify((Event)new InvalidURLEvent(url), source);
        }
    }
}

