/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.util.ParserUtils;

@Component
@Singleton
public class DefaultMacroContentParser
implements MacroContentParser {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RenderingContext renderingContext;
    private ParserUtils parserUtils = new ParserUtils();

    @Override
    public XDOM parse(String content, MacroTransformationContext macroContext, boolean transform, boolean inline) throws MacroExecutionException {
        return this.parse(content, macroContext, transform, null, inline);
    }

    @Override
    public XDOM parse(String content, MacroTransformationContext macroContext, boolean transform, MetaData metadata, boolean inline) throws MacroExecutionException {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return new XDOM(Collections.emptyList(), metadata != null ? metadata : MetaData.EMPTY);
        }
        Syntax syntax = this.getCurrentSyntax(macroContext);
        if (syntax == null) {
            throw new MacroExecutionException("Invalid Transformation: missing Syntax");
        }
        return this.createXDOM(content, macroContext, transform, metadata, inline, syntax);
    }

    private XDOM createXDOM(String content, MacroTransformationContext macroContext, boolean transform, MetaData metadata, boolean inline, Syntax syntax) throws MacroExecutionException {
        try {
            XDOM result = this.getSyntaxParser(syntax).parse((Reader)new StringReader(content));
            if (metadata != null) {
                result.getMetaData().addMetaData(metadata);
            }
            if (transform && macroContext.getTransformation() != null) {
                TransformationContext txContext = new TransformationContext(result, syntax);
                txContext.setId(macroContext.getId());
                this.performTransformation((MutableRenderingContext)this.renderingContext, macroContext.getTransformation(), txContext, (Block)result);
            }
            if (inline) {
                result = this.convertToInline(result);
            }
            return result;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "]", e);
        }
    }

    private void performTransformation(MutableRenderingContext renderingContext, Transformation transformation, TransformationContext context, Block block) throws MacroExecutionException {
        try {
            renderingContext.transformInContext(transformation, context, block);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to perform transformation", e);
        }
    }

    private XDOM convertToInline(XDOM xdom) {
        ArrayList<MacroBlock> blocks = new ArrayList<MacroBlock>(xdom.getChildren());
        if (!blocks.isEmpty()) {
            MacroBlock macro;
            this.parserUtils.removeTopLevelParagraph(blocks);
            Block block = (Block)blocks.get(0);
            if (block instanceof MacroBlock && !(macro = (MacroBlock)block).isInline()) {
                blocks.set(0, new MacroBlock(macro.getId(), macro.getParameters(), macro.getContent(), true));
            }
            xdom.setChildren(blocks);
        }
        return xdom;
    }

    private Parser getSyntaxParser(Syntax syntax) throws MacroExecutionException {
        try {
            return (Parser)this.componentManager.getInstance(Parser.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + syntax + "]", e);
        }
    }

    @Override
    public Syntax getCurrentSyntax(MacroTransformationContext context) {
        MetaDataBlock metaDataBlock;
        Syntax currentSyntax = context.getSyntax();
        MacroBlock currentMacroBlock = context.getCurrentMacroBlock();
        if (currentMacroBlock != null && (metaDataBlock = (MetaDataBlock)currentMacroBlock.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("syntax"), Block.Axes.ANCESTOR_OR_SELF)) != null) {
            currentSyntax = (Syntax)metaDataBlock.getMetaData().getMetaData("syntax");
        }
        return currentSyntax;
    }
}

