/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.OrBlockMatcher;
import org.xwiki.rendering.util.ErrorBlockGenerator;

public class MacroErrorManager {
    private ErrorBlockGenerator errorBlockGenerator;

    public MacroErrorManager(ErrorBlockGenerator errorBlockGenerator) {
        this.errorBlockGenerator = errorBlockGenerator;
    }

    public void generateError(MacroBlock macroToReplace, String message, String description) {
        List errorBlocks = this.errorBlockGenerator.generateErrorBlocks(message, description, macroToReplace.isInline());
        macroToReplace.getParent().replaceChild(this.wrapInMacroMarker(macroToReplace, errorBlocks), (Block)macroToReplace);
    }

    public void generateError(MacroBlock macroToReplace, String message, Throwable throwable) {
        List errorBlocks = this.errorBlockGenerator.generateErrorBlocks(message, throwable, macroToReplace.isInline());
        macroToReplace.getParent().replaceChild(this.wrapInMacroMarker(macroToReplace, errorBlocks), (Block)macroToReplace);
    }

    public boolean containsError(XDOM xdom) {
        boolean foundError = false;
        List groupAndFormatBlocks = xdom.getBlocks((BlockMatcher)new OrBlockMatcher(new BlockMatcher[]{new ClassBlockMatcher(GroupBlock.class), new ClassBlockMatcher(FormatBlock.class)}), Block.Axes.DESCENDANT);
        for (Block block : groupAndFormatBlocks) {
            String classParameter = (String)block.getParameters().get("class");
            if (classParameter == null || !classParameter.contains("xwikirenderingerror")) continue;
            foundError = true;
            break;
        }
        return foundError;
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }
}

