/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.macro.parameter;

/**
 * Exception used when the macro parameter is two high.
 * 
 * @version $Id: ParameterValueTooHighException.java 32245 2010-10-28 15:15:10Z vmassol $
 * @deprecated use {@link javax.validation.constraints.Max} instead
 */
@Deprecated
public class ParameterValueTooHighException extends MacroParameterException
{
    /**
     * Class ID for serialization.
     */
    private static final long serialVersionUID = 7152422251909335648L;

    /**
     * @param maxValue the maximum valid number
     */
    public ParameterValueTooHighException(int maxValue)
    {
        super("The value is too high. The highest allowed value is " + maxValue + ".");
    }
}
