/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.OrBlockMatcher;
import org.xwiki.rendering.listener.Format;

public class MacroErrorManager {
    private static final String CLASS_PARAMETER_NAME = "class";
    private static final String CLASS_PARAMETER_VALUE = "xwikirenderingerror";

    public void generateError(MacroBlock macroToReplace, String message, String description) {
        ArrayList<Block> errorBlocks = new ArrayList<Block>();
        Map<String, String> errorBlockParams = Collections.singletonMap(CLASS_PARAMETER_NAME, CLASS_PARAMETER_VALUE);
        Map<String, String> errorDescriptionBlockParams = Collections.singletonMap(CLASS_PARAMETER_NAME, "xwikirenderingerrordescription hidden");
        VerbatimBlock descriptionBlock = new VerbatimBlock(description, macroToReplace.isInline());
        if (macroToReplace.isInline()) {
            errorBlocks.add((Block)new FormatBlock(Arrays.asList(new WordBlock(message)), Format.NONE, errorBlockParams));
            errorBlocks.add((Block)new FormatBlock(Arrays.asList(descriptionBlock), Format.NONE, errorDescriptionBlockParams));
        } else {
            errorBlocks.add((Block)new GroupBlock(Arrays.asList(new WordBlock(message)), errorBlockParams));
            errorBlocks.add((Block)new GroupBlock(Arrays.asList(descriptionBlock), errorDescriptionBlockParams));
        }
        macroToReplace.getParent().replaceChild(this.wrapInMacroMarker(macroToReplace, errorBlocks), (Block)macroToReplace);
    }

    public void generateError(MacroBlock macroToReplace, String message, Throwable throwable) {
        String augmentedMessage = String.format("%s%sClick on this message for details.", message, message.trim().endsWith(".") ? " " : ". ");
        this.generateError(macroToReplace, augmentedMessage, ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    public boolean containsError(XDOM xdom) {
        boolean foundError = false;
        List groupAndFormatBlocks = xdom.getBlocks((BlockMatcher)new OrBlockMatcher(new BlockMatcher[]{new ClassBlockMatcher(GroupBlock.class), new ClassBlockMatcher(FormatBlock.class)}), Block.Axes.DESCENDANT);
        for (Block block : groupAndFormatBlocks) {
            String classParameter = (String)block.getParameters().get(CLASS_PARAMETER_NAME);
            if (classParameter == null || !classParameter.contains(CLASS_PARAMETER_VALUE)) continue;
            foundError = true;
            break;
        }
        return foundError;
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }
}

