/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.wikiword;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.internal.block.ProtectedBlockFilter;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.transformation.AbstractTransformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Named(value="wikiword")
@Singleton
public class WikiWordTransformation
extends AbstractTransformation {
    private static final Pattern WIKIWORD_PATTERN = Pattern.compile("\\p{javaUpperCase}+\\p{javaLowerCase}+(\\p{javaUpperCase}\\p{javaLowerCase}*)+");
    private ProtectedBlockFilter filter = new ProtectedBlockFilter();

    public void transform(Block block, TransformationContext transformationContext) throws TransformationException {
        for (WordBlock wordBlock : this.filter.getChildrenByType(block, WordBlock.class, true)) {
            Matcher matcher = WIKIWORD_PATTERN.matcher(wordBlock.getWord());
            if (!matcher.matches()) continue;
            DocumentResourceReference linkReference = new DocumentResourceReference(wordBlock.getWord());
            wordBlock.getParent().replaceChild((Block)new LinkBlock(wordBlock.getChildren(), (ResourceReference)linkReference, false), (Block)wordBlock);
        }
    }
}

