/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xwiki.xwiki10;

import org.xwiki.rendering.wikimodel.IWikiPrinter;
import org.xwiki.rendering.wikimodel.PrintTextListener;
import org.xwiki.rendering.wikimodel.WikiParameters;

public class XWikiSerializer
extends PrintTextListener {
    private boolean fNewTableRow;

    public XWikiSerializer(IWikiPrinter printer) {
        super(printer);
    }

    @Override
    public void beginHeader(int headerLevel, WikiParameters params) {
        this.print("1");
        for (int i = 0; i < headerLevel - 1; ++i) {
            this.print(".1");
        }
        this.print(" ");
    }

    @Override
    public void beginListItem() {
        this.print("* ");
    }

    @Override
    public void beginListItem(WikiParameters params) {
        this.print("* ");
    }

    @Override
    public void beginTable(WikiParameters params) {
        this.println("{table}");
    }

    @Override
    public void beginTableCell(boolean tableHead, WikiParameters params) {
        if (!this.fNewTableRow) {
            this.print("|");
        }
        this.fNewTableRow = false;
    }

    @Override
    public void beginTableRow(WikiParameters params) {
        this.fNewTableRow = true;
    }

    @Override
    public void endHeader(int headerLevel, WikiParameters params) {
        this.println();
        this.println();
    }

    @Override
    public void endList(WikiParameters params, boolean ordered) {
        this.println();
    }

    @Override
    public void endListItem() {
        this.println();
    }

    @Override
    public void endListItem(WikiParameters params) {
        this.println();
    }

    @Override
    public void endParagraph(WikiParameters params) {
        this.println();
        this.println();
    }

    @Override
    public void endTable(WikiParameters params) {
        this.println("{table}");
        this.println();
    }

    @Override
    public void endTableRow(WikiParameters params) {
        this.println();
    }

    protected String getEol() {
        return "\n";
    }

    public void onHorizontalLine() {
        this.println("----");
    }

    @Override
    public void onLineBreak() {
        this.println();
        this.println();
    }

    @Override
    public void onReference(String ref) {
        if (ref.indexOf("Image") == 0) {
            this.print("{image" + ref.substring(5) + "}");
        } else {
            int index = ref.indexOf("|");
            if (index > 0) {
                String label = ref.substring(index + 1);
                String link = ref.substring(0, index);
                link = link.replaceAll(" ", "_");
                this.print("[" + label + ">" + link + "]");
            } else {
                ref = ref.replaceAll(" ", "_");
                this.print("[" + ref + "]");
            }
        }
    }

    @Override
    public void onSpecialSymbol(String str) {
        this.print(str);
    }

    @Override
    public void onTableCaption(String str) {
        this.println(str);
    }

    @Override
    public void onVerbatimInline(String str, WikiParameters params) {
        this.println("{code}");
        this.println(str);
        this.println("{code}");
    }
}

