/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class ReferenceTagHandler
extends TagHandler {
    public ReferenceTagHandler() {
        super(true);
    }

    @Override
    protected void begin(TagContext context) {
        this.setAccumulateContent(true);
    }

    @Override
    protected void end(TagContext context) {
        WikiParameters parameters = context.getParams();
        WikiParameter ref = parameters.getParameter("href");
        if (ref != null) {
            if (this.isFreeStandingReference(context)) {
                context.getScannerContext().onReference(ref.getValue());
            } else {
                String content = context.getContent();
                WikiReference reference = new WikiReference(ref.getValue(), content, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onReference(reference);
            }
        }
    }

    protected boolean isFreeStandingReference(TagContext context) {
        boolean isFreeStanding;
        WikiParameters parameters = context.getParams();
        WikiParameter classParam = context.getParams().getParameter("class");
        boolean bl = isFreeStanding = classParam != null && "wikimodel-freestanding".equalsIgnoreCase(classParam.getValue());
        if (isFreeStanding) {
            return (parameters = this.removeMeaningfulParameters(parameters)).getSize() == 0;
        }
        return false;
    }

    protected WikiParameters removeFreestanding(WikiParameters parameters) {
        boolean isFreeStanding;
        WikiParameter classParam = parameters.getParameter("class");
        boolean bl = isFreeStanding = classParam != null && "wikimodel-freestanding".equalsIgnoreCase(classParam.getValue());
        if (isFreeStanding) {
            parameters = parameters.remove("class");
        }
        return parameters;
    }

    protected WikiParameters removeMeaningfulParameters(WikiParameters parameters) {
        return this.removeFreestanding(parameters).remove("href");
    }
}

