/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;

public class TagHandler {
    private boolean fAccumulateContent;
    private final boolean fContentContainer;

    public TagHandler(boolean contentContainer) {
        this.fContentContainer = contentContainer;
    }

    protected void begin(TagContext context) {
    }

    public void beginElement(TagContext context) {
        if (this.isBlockHandler(context)) {
            if (context.getTagStack().isInsideBlockElement()) {
                this.beginDocument(context);
                context.getTagStack().setDocumentParent();
            }
            context.getTagStack().setInsideBlockElement();
        }
        this.begin(context);
    }

    protected void end(TagContext context) {
    }

    public final void endElement(TagContext context) {
        if (context == context.getTagStack().getDocumentParent()) {
            this.endDocument(context);
            context.getTagStack().setInsideBlockElement();
        }
        this.end(context);
        if (this.isBlockHandler(context)) {
            context.getTagStack().unsetInsideBlockElement();
        }
    }

    public boolean isContentContainer() {
        return this.fContentContainer;
    }

    public void setAccumulateContent(boolean accumulateContent) {
        this.fAccumulateContent = accumulateContent;
    }

    public boolean isAccumulateContent() {
        return this.fAccumulateContent;
    }

    public static void sendEmptyLines(TagContext context) {
        TagHandler.sendEmptyLines(context.getTagStack());
    }

    public static void sendEmptyLines(TagStack stack) {
        int lineCount = stack.getEmptyLinesCount();
        if (lineCount > 0) {
            stack.getScannerContext().getfListener().onEmptyLines(lineCount);
            stack.resetEmptyLinesCount();
        }
    }

    public void initialize(TagStack stack) {
    }

    public boolean isBlockHandler(TagContext context) {
        return false;
    }

    protected void beginDocument(TagContext context) {
        this.beginDocument(context, null);
    }

    protected void beginDocument(TagContext context, WikiParameters params) {
        TagHandler.sendEmptyLines(context);
        if (params == null) {
            context.getScannerContext().beginDocument();
        } else {
            context.getScannerContext().beginDocument(params);
        }
        context.getTagStack().pushStackParameters();
        context.getTagStack().unsetInsideBlockElement();
    }

    protected void endDocument(TagContext context) {
        context.getTagStack().popStackParameters();
        TagHandler.sendEmptyLines(context);
        context.getScannerContext().endDocument();
    }
}

