/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.mediawiki;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.WikiReferenceParser;

public class MediaWikiReferenceParser
extends WikiReferenceParser {
    private static final String PREFIX_IMAGE = "^\\s*(?:i|I)mage:.*";
    private static final String PREFIX_FILE = "^\\s*(?:f|F)ile:.*";
    private static final String PREFIX_MAILTO = "^\\s*(?:m|M)ailto:.*";
    private static final List<String> format = Arrays.asList("border", "frame", "thumb", "frameless");
    private static final List<String> align = Arrays.asList("left", "right", "center", "none");
    private static final List<String> valign = Arrays.asList("baseline", "sub", "super", "top", "text-top", "middle", "bottom", "text-bottom");

    @Override
    public WikiReference parse(String str) {
        WikiReference wikiReference;
        str = str.trim();
        String reference = null;
        String label = null;
        if (str.contains("|")) {
            reference = str.substring(0, str.indexOf(124));
            label = str.substring(str.indexOf(124) + 1);
        } else {
            reference = str;
        }
        if (reference.matches(PREFIX_IMAGE) || reference.matches(PREFIX_FILE)) {
            reference = reference.substring(reference.indexOf(58) + 1);
            if (label != null) {
                WikiParameters params = this.generateImageParams(label);
                label = params.getParameter("alt") != null ? params.getParameter("alt").getValue() : "";
                if (params.getParameter("title") == null && "".equals(label)) {
                    params.addParameter("title", label);
                }
                return new WikiReference(reference, label, params);
            }
            return new WikiReference(reference);
        }
        if (-1 != str.indexOf(32) && (str.contains("://") || str.matches(PREFIX_MAILTO))) {
            String link = str.substring(0, str.indexOf(32)).trim();
            label = str.substring(str.indexOf(32) + 1).trim();
            wikiReference = new WikiReference(link, label);
        } else {
            wikiReference = new WikiReference(reference, label);
        }
        return wikiReference;
    }

    private WikiParameters generateImageParams(String paramString) {
        String[] params;
        ArrayList<WikiParameter> paramsList = new ArrayList<WikiParameter>();
        for (String param : params = paramString.split("[|]")) {
            if (param.indexOf("=") != -1) {
                String[] p = param.split("[=]");
                if (p.length > 1) {
                    paramsList.add(new WikiParameter(p[0], p[1]));
                    continue;
                }
                paramsList.add(new WikiParameter(p[0], ""));
                continue;
            }
            if (format.contains(param.toLowerCase())) {
                paramsList.add(new WikiParameter("format", param));
                continue;
            }
            if (align.contains(param.toLowerCase())) {
                paramsList.add(new WikiParameter("align", param));
                continue;
            }
            if (valign.contains(param.toLowerCase())) {
                paramsList.add(new WikiParameter("valign", param));
                continue;
            }
            if (param.toLowerCase().matches("[0-9]*px")) {
                paramsList.add(new WikiParameter("width", param));
                continue;
            }
            if (param.toLowerCase().matches("[0-9]*x[0-9]*px")) {
                paramsList.add(new WikiParameter("width", param.substring(0, param.indexOf("x")) + "px"));
                paramsList.add(new WikiParameter("height", param.substring(param.indexOf("x") + 1)));
                continue;
            }
            paramsList.add(new WikiParameter("alt", param));
        }
        return new WikiParameters(paramsList);
    }
}

