/* Generated By:JavaCC: Do not edit this line. XWikiScannerTokenManager.java */
/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc;
import org.xwiki.rendering.wikimodel.IWikiReferenceParser;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.WikiStyle;
import org.xwiki.rendering.wikimodel.impl.IWikiScannerContext;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiReferenceParser;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiScannerUtil;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiWikiParameters;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

/** Token Manager. */
public class XWikiScannerTokenManager implements XWikiScannerConstants
{
    public static final Pattern MACRO_NAME_PATTERN = Pattern.compile("^\u005c\u005c{\u005c\u005c{[/]?[\u0000- ]*(.*?)[\u0000- \u005c\u005c}/]");

    int verbatimBlockDepth = 0;
    int tableDepth = 0;
    String macroName = "";
    int macroDepth = 0;
    void initMacro(CharSequence buf) {
        macroName = getMacroName(buf);
        macroDepth = 1;
    }
    String getMacroName(CharSequence buf) {
        Matcher matcher = MACRO_NAME_PATTERN.matcher(buf);
        if (!matcher.find()) {
            // This must not be reachable.  I.e., make sure MACRO_NAME_PATTERN matches <MACRO_START> and <MACRO_END>.
            throw new RuntimeException(String.format("Didn't match macro name pattern: [%s].", buf.toString()));
        }
        return matcher.group(1);
    }

    /*
     * The lexical scanner operates in four different categories of
     * states:
     *
     * * base states: INLINE
     * * beginning of line state: BEGINNING_OF_LINE
     * * block states: TABLE_CONTEXT, HEADER_CONTEXT
     * * special states: VERBATIM_CONTEXT, MACRO_CONTEXT
     *
     * Except for state transitions to BEGINNING_OF_LINE and to
     * special states, we need to control the state transitions in
     * java code.  For this control the state we keep two variables:
     *
     * * preceedingSpecialState
     * * stateStack
     *
     * And we use the below five operations for switching lexical state.
     * 
     * * returnFromSpecialState()        - Called to switch from a
     *                                     a special state.
     * * enterBlockState(int state)      - Called instead of switching
     *                                     to a block state directly.
     * * pushStateControl()              - Called when entering an
     *                                     embedded document.
     * * popControlState()               - Called when leaving an
     *                                     embedded document.  Restores
     *                                     control variables and switches
     *                                     back to the state the
     *                                     corresponding pushStateControl
     *                                     was called from.
     *
     */

    private class LexStateControl {
        private int preceedingSpecialState;
        LexStateControl() {
            preceedingSpecialState = INLINE;
        }
        public void clearBlockState() {
            preceedingSpecialState = INLINE;
        }
        public void returnFromSpecialState() {
            SwitchTo(preceedingSpecialState);
        }
        public void enterBlockState(int state) {
            preceedingSpecialState = state;
            SwitchTo(state);
        }
    }

    private class ControlState {
        private final int curLexState;
        private final LexStateControl lexStateControl;
        ControlState(int curLexState, LexStateControl lexStateControl) {
            this.curLexState = curLexState;
            this.lexStateControl = lexStateControl;
        }

        public int getCurLexState() {
            return this.curLexState;
        }

        public LexStateControl getLexStateControl() {
            return this.lexStateControl;
        }

    }
    private final Stack<ControlState> controlStateStack = new Stack<ControlState>();

    LexStateControl lexStateControl = new LexStateControl();

    private void clearBlockState() { lexStateControl.clearBlockState(); }
    private void returnFromSpecialState() { lexStateControl.returnFromSpecialState(); }
    private void returnFromBeginningOfLine() { returnFromSpecialState(); }
    private void enterBlockState(int state) { lexStateControl.enterBlockState(state); }

    private void pushControlState() {
        controlStateStack.push(new ControlState(curLexState, lexStateControl));
        lexStateControl = new LexStateControl();
        SwitchTo(BEGINNING_OF_LINE);
    }

    private void popControlState() {
        ControlState s = controlStateStack.pop();
        lexStateControl = s.getLexStateControl();
        SwitchTo(s.getCurLexState());
    }

    private boolean inEmbeddedDocument() {
        return controlStateStack.size() > 0;
    }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private int jjMoveStringLiteralDfa0_0()
{
   return 1;
}
private int jjMoveStringLiteralDfa0_1()
{
   return jjMoveNfa_1(12, 0);
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 65;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 12:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(0, 5);
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 7)
                        kind = 7;
                  }
                  else if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(8, 4);
                  else if ((0x2040000000000L & l) != 0L)
                     jjCheckNAddTwoStates(5, 6);
                  else if (curChar == 40)
                     jjAddStates(6, 8);
                  else if (curChar == 33)
                     jjAddStates(9, 10);
                  else if (curChar == 62)
                  {
                     if (kind > 8)
                        kind = 8;
                     jjCheckNAdd(19);
                  }
                  else if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 11;
                  else if (curChar == 61)
                  {
                     if (kind > 2)
                        kind = 2;
                     jjCheckNAddTwoStates(0, 1);
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  else if (curChar == 42)
                     jjCheckNAddStates(11, 13);
                  break;
               case 0:
                  if (curChar != 61)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAddTwoStates(0, 1);
                  break;
               case 1:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjCheckNAdd(1);
                  break;
               case 2:
                  if (curChar == 42)
                     jjCheckNAddStates(11, 13);
                  break;
               case 3:
                  if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(3, 4);
                  break;
               case 4:
                  if ((0x100000200L & l) != 0L && kind > 3)
                     kind = 3;
                  break;
               case 5:
                  if ((0x2040000000000L & l) != 0L)
                     jjCheckNAddTwoStates(5, 6);
                  break;
               case 6:
                  if (curChar == 46)
                     jjCheckNAddTwoStates(7, 4);
                  break;
               case 7:
                  if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(7, 4);
                  break;
               case 8:
                  if ((0xc00000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(8, 4);
                  break;
               case 9:
                  if (curChar == 45)
                     jjCheckNAdd(10);
                  break;
               case 10:
                  if (curChar != 45)
                     break;
                  if (kind > 4)
                     kind = 4;
                  jjCheckNAdd(10);
                  break;
               case 11:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 13:
                  if (curChar == 61 && kind > 5)
                     kind = 5;
                  break;
               case 16:
                  if (curChar == 10 && kind > 7)
                     kind = 7;
                  break;
               case 17:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if ((0x2400L & l) != 0L && kind > 7)
                     kind = 7;
                  break;
               case 19:
                  if (curChar != 62)
                     break;
                  if (kind > 8)
                     kind = 8;
                  jjCheckNAdd(19);
                  break;
               case 20:
                  if (curChar == 33)
                     jjAddStates(9, 10);
                  break;
               case 21:
                  if (curChar == 33 && kind > 5)
                     kind = 5;
                  break;
               case 22:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(0, 5);
                  break;
               case 23:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(23, 0);
                  break;
               case 24:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(14, 17);
                  break;
               case 25:
                  if (curChar == 40)
                     jjAddStates(6, 8);
                  break;
               case 26:
                  if (curChar == 37)
                     jjCheckNAddStates(18, 21);
                  break;
               case 28:
                  jjCheckNAddStates(18, 21);
                  break;
               case 29:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(18, 21);
                  break;
               case 30:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 31:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(18, 21);
                  break;
               case 32:
                  if (curChar == 37)
                     jjAddStates(22, 23);
                  break;
               case 34:
                  if (curChar == 41)
                     jjCheckNAddStates(24, 27);
                  break;
               case 35:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(24, 27);
                  break;
               case 36:
                  if (curChar == 37)
                     jjCheckNAddStates(28, 31);
                  break;
               case 38:
                  jjCheckNAddStates(28, 31);
                  break;
               case 39:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(28, 31);
                  break;
               case 40:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 41:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(28, 31);
                  break;
               case 42:
                  if (curChar == 37)
                     jjAddStates(32, 33);
                  break;
               case 44:
                  if (curChar == 41)
                     jjAddStates(34, 35);
                  break;
               case 45:
                  if (curChar == 10 && kind > 6)
                     kind = 6;
                  break;
               case 46:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 47:
                  if ((0x2400L & l) != 0L && kind > 6)
                     kind = 6;
                  break;
               case 48:
                  if (curChar == 37)
                     jjCheckNAddStates(36, 39);
                  break;
               case 50:
                  jjCheckNAddStates(36, 39);
                  break;
               case 51:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(36, 39);
                  break;
               case 52:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 53;
                  break;
               case 53:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(36, 39);
                  break;
               case 54:
                  if (curChar == 37)
                     jjAddStates(40, 41);
                  break;
               case 56:
                  if (curChar == 41)
                     jjCheckNAddStates(42, 45);
                  break;
               case 57:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(42, 45);
                  break;
               case 58:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(59, 62);
                  break;
               case 59:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(59, 62);
                  break;
               case 60:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 61:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 62:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 63:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 58;
                  break;
               case 64:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(59, 62);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 12:
                  if (curChar == 124)
                  {
                     if (kind > 5)
                        kind = 5;
                  }
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 14:
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 124 && kind > 5)
                     kind = 5;
                  break;
               case 27:
               case 33:
                  if (curChar == 126)
                     jjCheckNAdd(28);
                  break;
               case 28:
                  jjCheckNAddStates(18, 21);
                  break;
               case 29:
               case 31:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(18, 21);
                  break;
               case 37:
               case 43:
                  if (curChar == 126)
                     jjCheckNAdd(38);
                  break;
               case 38:
                  jjCheckNAddStates(28, 31);
                  break;
               case 39:
               case 41:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(28, 31);
                  break;
               case 49:
               case 55:
                  if (curChar == 126)
                     jjCheckNAdd(50);
                  break;
               case 50:
                  jjCheckNAddStates(36, 39);
                  break;
               case 51:
               case 53:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(36, 39);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 28:
               case 29:
               case 31:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(18, 21);
                  break;
               case 38:
               case 39:
               case 41:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(28, 31);
                  break;
               case 50:
               case 51:
               case 53:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(36, 39);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 65 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_6(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 90;
            return 156;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            jjmatchedKind = 90;
            return -1;
         }
         return -1;
      case 1:
         if ((active1 & 0x100L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return 217;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_6(int pos, long active0, long active1)
{
   return jjMoveNfa_6(jjStopStringLiteralDfa_6(pos, active0, active1), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_6()
{
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_6(0x20000L);
      case 42:
         return jjMoveStringLiteralDfa1_6(0x800L);
      case 44:
         return jjMoveStringLiteralDfa1_6(0x10000L);
      case 45:
         return jjMoveStringLiteralDfa1_6(0x2000L);
      case 47:
         return jjMoveStringLiteralDfa1_6(0x1000L);
      case 92:
         return jjMoveStringLiteralDfa1_6(0x100000L);
      case 94:
         return jjMoveStringLiteralDfa1_6(0x8000L);
      case 95:
         return jjMoveStringLiteralDfa1_6(0x4000L);
      case 123:
         return jjMoveStringLiteralDfa1_6(0x100L);
      default :
         return jjMoveNfa_6(23, 0);
   }
}
private int jjMoveStringLiteralDfa1_6(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 35:
         if ((active1 & 0x20000L) != 0L)
            return jjStopAtPos(1, 81);
         break;
      case 42:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(1, 75);
         break;
      case 44:
         if ((active1 & 0x10000L) != 0L)
            return jjStopAtPos(1, 80);
         break;
      case 45:
         if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(1, 77);
         break;
      case 47:
         if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(1, 76);
         break;
      case 92:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      case 94:
         if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(1, 79);
         break;
      case 95:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 123:
         return jjMoveStringLiteralDfa2_6(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_6(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_6(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_6(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x100L) != 0L)
            return jjStopAtPos(2, 72);
         break;
      default :
         break;
   }
   return jjStartNfa_6(1, 0L, active1);
}
private int jjMoveNfa_6(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 217;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 217:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(46, 50);
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(51, 55);
                  break;
               case 23:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0xfc00fffe00000000L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                     jjCheckNAddTwoStates(214, 215);
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     jjCheckNAddStates(56, 61);
                  }
                  if (curChar == 13)
                     jjAddStates(62, 63);
                  else if (curChar == 40)
                     jjCheckNAddStates(64, 66);
                  else if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 1:
                  if (curChar == 58)
                     jjCheckNAddStates(67, 70);
                  break;
               case 3:
               case 4:
                  jjCheckNAddStates(67, 70);
                  break;
               case 17:
               case 18:
                  jjCheckNAddStates(71, 75);
                  break;
               case 24:
                  if (curChar != 58)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 25:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 28:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 35:
                  if (curChar != 58)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 36:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 39:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 47:
                  if (curChar == 58)
                     jjAddStates(76, 78);
                  break;
               case 48:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(79, 82);
                  break;
               case 49:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 50:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 53:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 54:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 55:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 56:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 58:
                  if (curChar != 63)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 59:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 60:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 61:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 63:
                  if (curChar != 35)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 64:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 65:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 66:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 68:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 71:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 74:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 75:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 76:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 77:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 78:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 80:
                  if ((0x2bff6fd200000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 88:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(106, 108);
                  break;
               case 89:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 91:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(109, 111);
                  break;
               case 92:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 119);
                  break;
               case 93:
                  if ((0x2fff6fd200000000L & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 94:
                  if (curChar == 37)
                     jjCheckNAdd(95);
                  break;
               case 95:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 98:
                  if (curChar == 37)
                     jjCheckNAdd(99);
                  break;
               case 99:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 101:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 102:
                  if (curChar == 58)
                     jjCheckNAdd(103);
                  break;
               case 103:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(129, 132);
                  break;
               case 104:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 105:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 106:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 107:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 109:
                  if (curChar == 37)
                     jjCheckNAddTwoStates(95, 99);
                  break;
               case 110:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 111:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 112:
                  if (curChar != 41)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 113:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 114:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 115:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 116:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 118:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 119:
                  if (curChar == 40)
                     jjCheckNAddStates(64, 66);
                  break;
               case 120:
                  if (curChar == 37)
                     jjCheckNAddStates(138, 141);
                  break;
               case 122:
                  jjCheckNAddStates(138, 141);
                  break;
               case 123:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(138, 141);
                  break;
               case 124:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 125;
                  break;
               case 125:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(138, 141);
                  break;
               case 126:
                  if (curChar == 37)
                     jjAddStates(142, 143);
                  break;
               case 128:
                  if (curChar == 41)
                     jjCheckNAddStates(144, 147);
                  break;
               case 129:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(144, 147);
                  break;
               case 130:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(131, 134);
                  break;
               case 131:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(131, 134);
                  break;
               case 132:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 133:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 132;
                  break;
               case 134:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 133;
                  break;
               case 135:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 130;
                  break;
               case 136:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(131, 134);
                  break;
               case 137:
                  if (curChar == 37)
                     jjCheckNAddStates(148, 151);
                  break;
               case 139:
                  jjCheckNAddStates(148, 151);
                  break;
               case 140:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(148, 151);
                  break;
               case 141:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 142;
                  break;
               case 142:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(148, 151);
                  break;
               case 143:
                  if (curChar == 37)
                     jjAddStates(152, 153);
                  break;
               case 145:
                  if (curChar == 41 && kind > 69)
                     kind = 69;
                  break;
               case 146:
                  if (curChar != 40)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(147);
                  break;
               case 147:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(147);
                  break;
               case 148:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 146;
                  break;
               case 149:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddStates(56, 61);
                  break;
               case 150:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(150, 151);
                  break;
               case 151:
                  if (curChar == 40)
                     jjCheckNAdd(148);
                  break;
               case 152:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddTwoStates(152, 153);
                  break;
               case 154:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(154, 115);
                  break;
               case 157:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(51, 55);
                  break;
               case 158:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(159);
                  break;
               case 159:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(154, 158);
                  break;
               case 160:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(159, 165);
                  break;
               case 161:
                  if (curChar == 34)
                     jjCheckNAddStates(166, 168);
                  break;
               case 163:
                  jjCheckNAddStates(166, 168);
                  break;
               case 164:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(166, 168);
                  break;
               case 165:
                  if (curChar == 34)
                     jjCheckNAddStates(159, 165);
                  break;
               case 166:
                  if (curChar == 39)
                     jjCheckNAddStates(169, 171);
                  break;
               case 168:
                  jjCheckNAddStates(169, 171);
                  break;
               case 169:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(169, 171);
                  break;
               case 170:
                  if (curChar == 39)
                     jjCheckNAddStates(159, 165);
                  break;
               case 172:
               case 175:
                  jjCheckNAddStates(159, 165);
                  break;
               case 173:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(159, 165);
                  break;
               case 180:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 179;
                  break;
               case 181:
                  if (curChar == 10)
                     jjCheckNAddStates(159, 165);
                  break;
               case 182:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 181;
                  break;
               case 184:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(46, 50);
                  break;
               case 185:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(186);
                  break;
               case 186:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(172, 176);
                  break;
               case 187:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(177, 182);
                  break;
               case 188:
                  if (curChar == 34)
                     jjCheckNAddStates(183, 185);
                  break;
               case 190:
                  jjCheckNAddStates(183, 185);
                  break;
               case 191:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(183, 185);
                  break;
               case 192:
                  if (curChar == 34)
                     jjCheckNAddStates(177, 182);
                  break;
               case 193:
                  if (curChar == 39)
                     jjCheckNAddStates(186, 188);
                  break;
               case 195:
                  jjCheckNAddStates(186, 188);
                  break;
               case 196:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(186, 188);
                  break;
               case 197:
                  if (curChar == 39)
                     jjCheckNAddStates(177, 182);
                  break;
               case 199:
               case 202:
                  jjCheckNAddStates(177, 182);
                  break;
               case 200:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(177, 182);
                  break;
               case 206:
                  if (curChar == 10)
                     jjCheckNAddStates(177, 182);
                  break;
               case 207:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 206;
                  break;
               case 210:
                  if (curChar == 13)
                     jjAddStates(62, 63);
                  break;
               case 211:
                  if (curChar == 10 && kind > 88)
                     kind = 88;
                  break;
               case 212:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(214, 215);
                  break;
               case 213:
                  if (curChar == 10 && kind > 93)
                     kind = 93;
                  break;
               case 214:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 213;
                  break;
               case 215:
                  if ((0x2400L & l) != 0L && kind > 93)
                     kind = 93;
                  break;
               case 216:
                  if ((0x2400L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjCheckNAddTwoStates(214, 215);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 217:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(46, 50);
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(51, 55);
                  break;
               case 23:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0x78000001f8000001L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(106, 108);
                  else if (curChar == 126)
                     jjCheckNAddStates(189, 191);
                  else if (curChar == 123)
                     jjAddStates(192, 193);
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 0;
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 156:
                  if (curChar == 123)
                     jjCheckNAdd(184);
                  if (curChar == 123)
                     jjCheckNAdd(157);
                  break;
               case 0:
                  if (curChar == 91)
                     jjCheckNAddStates(71, 75);
                  break;
               case 2:
               case 7:
                  if (curChar == 126)
                     jjCheckNAdd(3);
                  break;
               case 3:
                  jjCheckNAddStates(67, 70);
                  break;
               case 4:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(67, 70);
                  break;
               case 5:
                  if (curChar == 93)
                     jjCheckNAdd(4);
                  break;
               case 6:
                  if (curChar == 93)
                     jjAddStates(194, 195);
                  break;
               case 8:
                  if (curChar == 93)
                     jjCheckNAddStates(71, 75);
                  break;
               case 9:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 10:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
               case 21:
                  if (curChar == 126)
                     jjCheckNAdd(17);
                  break;
               case 17:
                  jjCheckNAddStates(71, 75);
                  break;
               case 18:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(71, 75);
                  break;
               case 19:
                  if (curChar == 93)
                     jjCheckNAdd(18);
                  break;
               case 20:
                  if (curChar == 93)
                     jjAddStates(196, 197);
                  break;
               case 22:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 25:
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 26:
                  if (curChar == 126)
                     jjAddStates(198, 200);
                  break;
               case 28:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 30:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 31:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 34:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 36:
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 37:
                  if (curChar == 126)
                     jjAddStates(201, 203);
                  break;
               case 39:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 41:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 42:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 43:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 49:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 51:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 54:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 56:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 59:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 61:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 64:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 66:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 69:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 72:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 74:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 76:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 78:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 80:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 81:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 82:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
               case 88:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(106, 108);
                  break;
               case 90:
               case 91:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(109, 111);
                  break;
               case 93:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 95:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 97:
                  if (curChar != 64)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 99:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 101:
                  if ((0x47fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 105:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 107:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 116:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 117:
                  if (curChar == 126)
                     jjCheckNAdd(116);
                  break;
               case 118:
                  if ((0x78000001f8000001L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 121:
               case 127:
                  if (curChar == 126)
                     jjCheckNAdd(122);
                  break;
               case 122:
                  jjCheckNAddStates(138, 141);
                  break;
               case 123:
               case 125:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(138, 141);
                  break;
               case 138:
               case 144:
                  if (curChar == 126)
                     jjCheckNAdd(139);
                  break;
               case 139:
                  jjCheckNAddStates(148, 151);
                  break;
               case 140:
               case 142:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(148, 151);
                  break;
               case 153:
                  if (curChar == 126)
                     jjCheckNAdd(152);
                  break;
               case 155:
                  if (curChar == 123)
                     jjAddStates(192, 193);
                  break;
               case 157:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(51, 55);
                  break;
               case 158:
                  if (curChar == 95)
                     jjCheckNAdd(159);
                  break;
               case 159:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(154, 158);
                  break;
               case 162:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 163;
                  break;
               case 163:
                  jjCheckNAddStates(166, 168);
                  break;
               case 164:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(166, 168);
                  break;
               case 167:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 168;
                  break;
               case 168:
                  jjCheckNAddStates(169, 171);
                  break;
               case 169:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(169, 171);
                  break;
               case 171:
               case 176:
                  if (curChar == 126)
                     jjCheckNAdd(172);
                  break;
               case 172:
                  jjCheckNAddStates(159, 165);
                  break;
               case 173:
               case 175:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(159, 165);
                  break;
               case 174:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 175;
                  break;
               case 177:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 176;
                  break;
               case 178:
                  if (curChar == 125 && kind > 73)
                     kind = 73;
                  break;
               case 179:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 178;
                  break;
               case 183:
                  if (curChar == 123)
                     jjCheckNAdd(184);
                  break;
               case 184:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(46, 50);
                  break;
               case 185:
                  if (curChar == 95)
                     jjCheckNAdd(186);
                  break;
               case 186:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(172, 176);
                  break;
               case 189:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 190;
                  break;
               case 190:
                  jjCheckNAddStates(183, 185);
                  break;
               case 191:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(183, 185);
                  break;
               case 194:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 195;
                  break;
               case 195:
                  jjCheckNAddStates(186, 188);
                  break;
               case 196:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(186, 188);
                  break;
               case 198:
               case 204:
                  if (curChar == 126)
                     jjCheckNAdd(199);
                  break;
               case 199:
                  jjCheckNAddStates(177, 182);
                  break;
               case 200:
               case 202:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(177, 182);
                  break;
               case 201:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 202;
                  break;
               case 203:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(204, 205);
                  break;
               case 205:
                  if (curChar == 125 && kind > 74)
                     kind = 74;
                  break;
               case 208:
                  if (curChar == 125)
                     jjCheckNAdd(205);
                  break;
               case 209:
                  if (curChar == 126)
                     jjCheckNAddStates(189, 191);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 217:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(51, 55);
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(46, 50);
                  break;
               case 23:
               case 116:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 3:
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(67, 70);
                  break;
               case 17:
               case 18:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(71, 75);
                  break;
               case 25:
               case 27:
               case 28:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 36:
               case 38:
               case 39:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 122:
               case 123:
               case 125:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(138, 141);
                  break;
               case 139:
               case 140:
               case 142:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(148, 151);
                  break;
               case 157:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(51, 55);
                  break;
               case 159:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(154, 158);
                  break;
               case 163:
               case 164:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(166, 168);
                  break;
               case 168:
               case 169:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(169, 171);
                  break;
               case 172:
               case 173:
               case 175:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(159, 165);
                  break;
               case 184:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(46, 50);
                  break;
               case 186:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(172, 176);
                  break;
               case 190:
               case 191:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(183, 185);
                  break;
               case 195:
               case 196:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(186, 188);
                  break;
               case 199:
               case 200:
               case 202:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(177, 182);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 217 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_5()
{
   return jjMoveNfa_5(0, 0);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 41;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 20)
                     kind = 20;
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 10 && kind > 20)
                     kind = 20;
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if ((0x3ff0000ffffd9ffL & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 5:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 8:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(204, 208);
                  break;
               case 9:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(10);
                  break;
               case 10:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(209, 213);
                  break;
               case 11:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(214, 219);
                  break;
               case 12:
                  if (curChar == 34)
                     jjCheckNAddStates(220, 222);
                  break;
               case 14:
                  jjCheckNAddStates(220, 222);
                  break;
               case 15:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(220, 222);
                  break;
               case 16:
                  if (curChar == 34)
                     jjCheckNAddStates(214, 219);
                  break;
               case 17:
                  if (curChar == 39)
                     jjCheckNAddStates(223, 225);
                  break;
               case 19:
                  jjCheckNAddStates(223, 225);
                  break;
               case 20:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(223, 225);
                  break;
               case 21:
                  if (curChar == 39)
                     jjCheckNAddStates(214, 219);
                  break;
               case 23:
               case 26:
                  jjCheckNAddStates(214, 219);
                  break;
               case 24:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(214, 219);
                  break;
               case 30:
                  if (curChar == 10)
                     jjCheckNAddStates(214, 219);
                  break;
               case 31:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 33:
                  if (curChar == 47)
                     jjCheckNAdd(34);
                  break;
               case 34:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(226, 229);
                  break;
               case 35:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(36);
                  break;
               case 36:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(230, 233);
                  break;
               case 37:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(37, 39);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (kind > 20)
                     kind = 20;
                  if (curChar == 123)
                     jjAddStates(234, 235);
                  else if (curChar == 126)
                     jjAddStates(236, 237);
                  break;
               case 3:
                  if (curChar == 126)
                     jjAddStates(236, 237);
                  break;
               case 4:
                  if ((0x87fffffe07fffffeL & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 5:
                  if ((0x78000001f8000001L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 6:
                  if (curChar == 123)
                     jjAddStates(234, 235);
                  break;
               case 7:
                  if (curChar == 123)
                     jjCheckNAdd(8);
                  break;
               case 8:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(204, 208);
                  break;
               case 9:
                  if (curChar == 95)
                     jjCheckNAdd(10);
                  break;
               case 10:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(209, 213);
                  break;
               case 13:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 14:
                  jjCheckNAddStates(220, 222);
                  break;
               case 15:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(220, 222);
                  break;
               case 18:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 19:
                  jjCheckNAddStates(223, 225);
                  break;
               case 20:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(223, 225);
                  break;
               case 22:
               case 28:
                  if (curChar == 126)
                     jjCheckNAdd(23);
                  break;
               case 23:
                  jjCheckNAddStates(214, 219);
                  break;
               case 24:
               case 26:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(214, 219);
                  break;
               case 25:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 27:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(28, 29);
                  break;
               case 29:
                  if (curChar == 125 && kind > 18)
                     kind = 18;
                  break;
               case 32:
                  if (curChar == 125)
                     jjCheckNAdd(29);
                  break;
               case 34:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(226, 229);
                  break;
               case 35:
                  if (curChar == 95)
                     jjCheckNAdd(36);
                  break;
               case 36:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(230, 233);
                  break;
               case 38:
                  if (curChar == 125 && kind > 19)
                     kind = 19;
                  break;
               case 39:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 40:
                  if (curChar == 123)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 20)
                     kind = 20;
                  break;
               case 8:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(204, 208);
                  break;
               case 10:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(209, 213);
                  break;
               case 14:
               case 15:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(220, 222);
                  break;
               case 19:
               case 20:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(223, 225);
                  break;
               case 23:
               case 24:
               case 26:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(214, 219);
                  break;
               case 34:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(226, 229);
                  break;
               case 36:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(230, 233);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 41 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_4()
{
   return jjMoveNfa_4(0, 0);
}
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 8:
               case 7:
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x97ffffffffffffffL & l) != 0L)
                  {
                     if (kind > 17)
                        kind = 17;
                     jjCheckNAddTwoStates(6, 8);
                  }
                  else if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 7;
                  else if (curChar == 125)
                  {
                     if (kind > 16)
                        kind = 16;
                     jjstateSet[jjnewStateCnt++] = 4;
                  }
                  else if (curChar == 123)
                  {
                     if (kind > 15)
                        kind = 15;
                     jjstateSet[jjnewStateCnt++] = 1;
                  }
                  break;
               case 1:
                  if (curChar != 123)
                     break;
                  if (kind > 15)
                     kind = 15;
                  jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 2:
                  if (curChar == 123 && kind > 15)
                     kind = 15;
                  break;
               case 3:
                  if (curChar != 125)
                     break;
                  if (kind > 16)
                     kind = 16;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if (curChar != 125)
                     break;
                  if (kind > 16)
                     kind = 16;
                  jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 5:
                  if (curChar == 125 && kind > 16)
                     kind = 16;
                  break;
               case 6:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 7:
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               case 8:
                  if ((0x97ffffffffffffffL & l) == 0L)
                     break;
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 8:
               case 7:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 17)
                     kind = 17;
                  jjCheckNAddTwoStates(6, 8);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 90;
            return 175;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            jjmatchedKind = 90;
            return -1;
         }
         return -1;
      case 1:
         if ((active1 & 0x100L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return 229;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0, long active1)
{
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_3()
{
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_3(0x20000L);
      case 42:
         return jjMoveStringLiteralDfa1_3(0x800L);
      case 44:
         return jjMoveStringLiteralDfa1_3(0x10000L);
      case 45:
         return jjMoveStringLiteralDfa1_3(0x2000L);
      case 47:
         return jjMoveStringLiteralDfa1_3(0x1000L);
      case 92:
         return jjMoveStringLiteralDfa1_3(0x100000L);
      case 94:
         return jjMoveStringLiteralDfa1_3(0x8000L);
      case 95:
         return jjMoveStringLiteralDfa1_3(0x4000L);
      case 123:
         return jjMoveStringLiteralDfa1_3(0x100L);
      default :
         return jjMoveNfa_3(23, 0);
   }
}
private int jjMoveStringLiteralDfa1_3(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 35:
         if ((active1 & 0x20000L) != 0L)
            return jjStopAtPos(1, 81);
         break;
      case 42:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(1, 75);
         break;
      case 44:
         if ((active1 & 0x10000L) != 0L)
            return jjStopAtPos(1, 80);
         break;
      case 45:
         if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(1, 77);
         break;
      case 47:
         if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(1, 76);
         break;
      case 92:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      case 94:
         if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(1, 79);
         break;
      case 95:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 123:
         return jjMoveStringLiteralDfa2_3(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_3(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_3(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_3(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x100L) != 0L)
            return jjStopAtPos(2, 72);
         break;
      default :
         break;
   }
   return jjStartNfa_3(1, 0L, active1);
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 229;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 229:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(238, 242);
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(243, 247);
                  break;
               case 23:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0xfc00fffe00000000L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                     jjCheckNAddStates(248, 251);
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     jjCheckNAddStates(252, 261);
                  }
                  if (curChar == 40)
                     jjCheckNAddStates(262, 264);
                  else if (curChar == 13)
                     jjAddStates(265, 267);
                  else if (curChar == 61)
                  {
                     if (kind > 13)
                        kind = 13;
                     jjCheckNAddStates(138, 141);
                  }
                  else if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 1:
                  if (curChar == 58)
                     jjCheckNAddStates(67, 70);
                  break;
               case 3:
               case 4:
                  jjCheckNAddStates(67, 70);
                  break;
               case 17:
               case 18:
                  jjCheckNAddStates(71, 75);
                  break;
               case 24:
                  if (curChar != 58)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 25:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 28:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 35:
                  if (curChar != 58)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 36:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 39:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 47:
                  if (curChar == 58)
                     jjAddStates(76, 78);
                  break;
               case 48:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(79, 82);
                  break;
               case 49:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 50:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 53:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 54:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 55:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 56:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 58:
                  if (curChar != 63)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 59:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 60:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 61:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 63:
                  if (curChar != 35)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 64:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 65:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 66:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 68:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 71:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 74:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 75:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 76:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 77:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 78:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 80:
                  if ((0x2bff6fd200000000L & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 88:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(106, 108);
                  break;
               case 89:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 91:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(109, 111);
                  break;
               case 92:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(112, 119);
                  break;
               case 93:
                  if ((0x2fff6fd200000000L & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 94:
                  if (curChar == 37)
                     jjCheckNAdd(95);
                  break;
               case 95:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 98:
                  if (curChar == 37)
                     jjCheckNAdd(99);
                  break;
               case 99:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 101:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 102:
                  if (curChar == 58)
                     jjCheckNAdd(103);
                  break;
               case 103:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(129, 132);
                  break;
               case 104:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 105:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 106:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 107:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 109:
                  if (curChar == 37)
                     jjCheckNAddTwoStates(95, 99);
                  break;
               case 110:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 111:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 112:
                  if (curChar != 41)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 113:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(113);
                  break;
               case 114:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 115:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 116:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 118:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 119:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddStates(252, 261);
                  break;
               case 120:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(120, 121);
                  break;
               case 121:
                  if (curChar == 61)
                     jjCheckNAddStates(268, 270);
                  break;
               case 122:
                  if (curChar == 10 && kind > 12)
                     kind = 12;
                  break;
               case 123:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 122;
                  break;
               case 124:
                  if ((0x2400L & l) != 0L && kind > 12)
                     kind = 12;
                  break;
               case 125:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(125, 126);
                  break;
               case 126:
                  if (curChar != 61)
                     break;
                  if (kind > 13)
                     kind = 13;
                  jjCheckNAdd(126);
                  break;
               case 127:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(127, 131);
                  break;
               case 128:
                  if (curChar != 40)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(129);
                  break;
               case 129:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(129);
                  break;
               case 130:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 128;
                  break;
               case 131:
                  if (curChar == 40)
                     jjCheckNAdd(130);
                  break;
               case 132:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddTwoStates(132, 133);
                  break;
               case 134:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(134, 115);
                  break;
               case 135:
                  if (curChar != 61)
                     break;
                  if (kind > 13)
                     kind = 13;
                  jjCheckNAddStates(138, 141);
                  break;
               case 136:
                  if (curChar == 13)
                     jjAddStates(265, 267);
                  break;
               case 137:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(138, 139);
                  break;
               case 138:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(138, 139);
                  break;
               case 139:
                  if (curChar != 61)
                     break;
                  if (kind > 14)
                     kind = 14;
                  jjCheckNAddTwoStates(139, 140);
                  break;
               case 140:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 14)
                     kind = 14;
                  jjCheckNAdd(140);
                  break;
               case 141:
                  if (curChar == 10 && kind > 88)
                     kind = 88;
                  break;
               case 142:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(144, 145);
                  break;
               case 143:
                  if (curChar == 10 && kind > 92)
                     kind = 92;
                  break;
               case 144:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 143;
                  break;
               case 145:
                  if ((0x2400L & l) != 0L && kind > 92)
                     kind = 92;
                  break;
               case 146:
                  if ((0x2400L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjCheckNAddStates(248, 251);
                  break;
               case 147:
                  if (curChar == 40)
                     jjCheckNAddStates(262, 264);
                  break;
               case 148:
                  if (curChar == 37)
                     jjCheckNAddStates(271, 274);
                  break;
               case 150:
                  jjCheckNAddStates(271, 274);
                  break;
               case 151:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(271, 274);
                  break;
               case 152:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 153;
                  break;
               case 153:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(271, 274);
                  break;
               case 154:
                  if (curChar == 37)
                     jjAddStates(275, 276);
                  break;
               case 156:
                  if (curChar == 41)
                     jjCheckNAddStates(277, 280);
                  break;
               case 157:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(277, 280);
                  break;
               case 158:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(159, 162);
                  break;
               case 159:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(159, 162);
                  break;
               case 160:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 161:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 160;
                  break;
               case 162:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 161;
                  break;
               case 163:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 158;
                  break;
               case 164:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(159, 162);
                  break;
               case 165:
                  if (curChar == 37)
                     jjCheckNAddStates(281, 284);
                  break;
               case 167:
                  jjCheckNAddStates(281, 284);
                  break;
               case 168:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(281, 284);
                  break;
               case 169:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 170;
                  break;
               case 170:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(281, 284);
                  break;
               case 171:
                  if (curChar == 37)
                     jjAddStates(285, 286);
                  break;
               case 173:
                  if (curChar == 41 && kind > 69)
                     kind = 69;
                  break;
               case 176:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(243, 247);
                  break;
               case 177:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(178);
                  break;
               case 178:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(287, 291);
                  break;
               case 179:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(292, 298);
                  break;
               case 180:
                  if (curChar == 34)
                     jjCheckNAddStates(299, 301);
                  break;
               case 182:
                  jjCheckNAddStates(299, 301);
                  break;
               case 183:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(299, 301);
                  break;
               case 184:
                  if (curChar == 34)
                     jjCheckNAddStates(292, 298);
                  break;
               case 185:
                  if (curChar == 39)
                     jjCheckNAddStates(302, 304);
                  break;
               case 187:
                  jjCheckNAddStates(302, 304);
                  break;
               case 188:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(302, 304);
                  break;
               case 189:
                  if (curChar == 39)
                     jjCheckNAddStates(292, 298);
                  break;
               case 191:
               case 194:
                  jjCheckNAddStates(292, 298);
                  break;
               case 192:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(292, 298);
                  break;
               case 199:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 198;
                  break;
               case 200:
                  if (curChar == 10)
                     jjCheckNAddStates(292, 298);
                  break;
               case 201:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 200;
                  break;
               case 203:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(238, 242);
                  break;
               case 204:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(205);
                  break;
               case 205:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(305, 309);
                  break;
               case 206:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(310, 315);
                  break;
               case 207:
                  if (curChar == 34)
                     jjCheckNAddStates(316, 318);
                  break;
               case 209:
                  jjCheckNAddStates(316, 318);
                  break;
               case 210:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(316, 318);
                  break;
               case 211:
                  if (curChar == 34)
                     jjCheckNAddStates(310, 315);
                  break;
               case 212:
                  if (curChar == 39)
                     jjCheckNAddStates(319, 321);
                  break;
               case 214:
                  jjCheckNAddStates(319, 321);
                  break;
               case 215:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(319, 321);
                  break;
               case 216:
                  if (curChar == 39)
                     jjCheckNAddStates(310, 315);
                  break;
               case 218:
               case 221:
                  jjCheckNAddStates(310, 315);
                  break;
               case 219:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(310, 315);
                  break;
               case 225:
                  if (curChar == 10)
                     jjCheckNAddStates(310, 315);
                  break;
               case 226:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 225;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 229:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(238, 242);
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(243, 247);
                  break;
               case 23:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(116, 117);
                  }
                  else if ((0x78000001f8000001L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(106, 108);
                  else if (curChar == 126)
                     jjCheckNAddStates(322, 324);
                  else if (curChar == 123)
                     jjAddStates(325, 326);
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 0;
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 175:
                  if (curChar == 123)
                     jjCheckNAdd(203);
                  if (curChar == 123)
                     jjCheckNAdd(176);
                  break;
               case 0:
                  if (curChar == 91)
                     jjCheckNAddStates(71, 75);
                  break;
               case 2:
               case 7:
                  if (curChar == 126)
                     jjCheckNAdd(3);
                  break;
               case 3:
                  jjCheckNAddStates(67, 70);
                  break;
               case 4:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(67, 70);
                  break;
               case 5:
                  if (curChar == 93)
                     jjCheckNAdd(4);
                  break;
               case 6:
                  if (curChar == 93)
                     jjAddStates(194, 195);
                  break;
               case 8:
                  if (curChar == 93)
                     jjCheckNAddStates(71, 75);
                  break;
               case 9:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 10:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
               case 21:
                  if (curChar == 126)
                     jjCheckNAdd(17);
                  break;
               case 17:
                  jjCheckNAddStates(71, 75);
                  break;
               case 18:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(71, 75);
                  break;
               case 19:
                  if (curChar == 93)
                     jjCheckNAdd(18);
                  break;
               case 20:
                  if (curChar == 93)
                     jjAddStates(196, 197);
                  break;
               case 22:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 25:
               case 27:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 26:
                  if (curChar == 126)
                     jjAddStates(198, 200);
                  break;
               case 28:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 29:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 30:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 31:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 34:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 36:
               case 38:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 37:
                  if (curChar == 126)
                     jjAddStates(201, 203);
                  break;
               case 39:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 40:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 41:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 42:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 43:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 49:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 51:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(83, 87);
                  break;
               case 54:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 56:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 57:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(88, 92);
                  break;
               case 59:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 61:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 62:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(93, 95);
                  break;
               case 64:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 66:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 67:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(64, 65);
                  break;
               case 69:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 72:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 74:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(96, 100);
                  break;
               case 76:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 78:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 79:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(101, 105);
                  break;
               case 80:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(71, 74);
                  break;
               case 81:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 82:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
               case 88:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(106, 108);
                  break;
               case 90:
               case 91:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(109, 111);
                  break;
               case 93:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 95:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 96:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddStates(120, 122);
                  break;
               case 97:
                  if (curChar != 64)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 99:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 100:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 101:
                  if ((0x47fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(123, 128);
                  break;
               case 105:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 107:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 108:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(133, 137);
                  break;
               case 116:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 117:
                  if (curChar == 126)
                     jjCheckNAdd(116);
                  break;
               case 118:
                  if ((0x78000001f8000001L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 133:
                  if (curChar == 126)
                     jjCheckNAdd(132);
                  break;
               case 149:
               case 155:
                  if (curChar == 126)
                     jjCheckNAdd(150);
                  break;
               case 150:
                  jjCheckNAddStates(271, 274);
                  break;
               case 151:
               case 153:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(271, 274);
                  break;
               case 166:
               case 172:
                  if (curChar == 126)
                     jjCheckNAdd(167);
                  break;
               case 167:
                  jjCheckNAddStates(281, 284);
                  break;
               case 168:
               case 170:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(281, 284);
                  break;
               case 174:
                  if (curChar == 123)
                     jjAddStates(325, 326);
                  break;
               case 176:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(243, 247);
                  break;
               case 177:
                  if (curChar == 95)
                     jjCheckNAdd(178);
                  break;
               case 178:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(287, 291);
                  break;
               case 181:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 182;
                  break;
               case 182:
                  jjCheckNAddStates(299, 301);
                  break;
               case 183:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(299, 301);
                  break;
               case 186:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 187;
                  break;
               case 187:
                  jjCheckNAddStates(302, 304);
                  break;
               case 188:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(302, 304);
                  break;
               case 190:
               case 195:
                  if (curChar == 126)
                     jjCheckNAdd(191);
                  break;
               case 191:
                  jjCheckNAddStates(292, 298);
                  break;
               case 192:
               case 194:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(292, 298);
                  break;
               case 193:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 194;
                  break;
               case 196:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 195;
                  break;
               case 197:
                  if (curChar == 125 && kind > 73)
                     kind = 73;
                  break;
               case 198:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 197;
                  break;
               case 202:
                  if (curChar == 123)
                     jjCheckNAdd(203);
                  break;
               case 203:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(238, 242);
                  break;
               case 204:
                  if (curChar == 95)
                     jjCheckNAdd(205);
                  break;
               case 205:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(305, 309);
                  break;
               case 208:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 209;
                  break;
               case 209:
                  jjCheckNAddStates(316, 318);
                  break;
               case 210:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(316, 318);
                  break;
               case 213:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 214;
                  break;
               case 214:
                  jjCheckNAddStates(319, 321);
                  break;
               case 215:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(319, 321);
                  break;
               case 217:
               case 223:
                  if (curChar == 126)
                     jjCheckNAdd(218);
                  break;
               case 218:
                  jjCheckNAddStates(310, 315);
                  break;
               case 219:
               case 221:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(310, 315);
                  break;
               case 220:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 221;
                  break;
               case 222:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(223, 224);
                  break;
               case 224:
                  if (curChar == 125 && kind > 74)
                     kind = 74;
                  break;
               case 227:
                  if (curChar == 125)
                     jjCheckNAdd(224);
                  break;
               case 228:
                  if (curChar == 126)
                     jjCheckNAddStates(322, 324);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 229:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(243, 247);
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(238, 242);
                  break;
               case 23:
               case 116:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(116, 117);
                  break;
               case 3:
               case 4:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(67, 70);
                  break;
               case 17:
               case 18:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(71, 75);
                  break;
               case 25:
               case 27:
               case 28:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(25, 26);
                  break;
               case 36:
               case 38:
               case 39:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(36, 37);
                  break;
               case 150:
               case 151:
               case 153:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(271, 274);
                  break;
               case 167:
               case 168:
               case 170:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(281, 284);
                  break;
               case 176:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(243, 247);
                  break;
               case 178:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(287, 291);
                  break;
               case 182:
               case 183:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(299, 301);
                  break;
               case 187:
               case 188:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(302, 304);
                  break;
               case 191:
               case 192:
               case 194:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(292, 298);
                  break;
               case 203:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(238, 242);
                  break;
               case 205:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(305, 309);
                  break;
               case 209:
               case 210:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(316, 318);
                  break;
               case 214:
               case 215:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(319, 321);
                  break;
               case 218:
               case 219:
               case 221:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(310, 315);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 229 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active1 & 0x100L) != 0L)
         {
            jjmatchedKind = 90;
            return 161;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            jjmatchedKind = 90;
            return -1;
         }
         return -1;
      case 1:
         if ((active1 & 0x100L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return 222;
         }
         if ((active1 & 0x13f800L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 90;
               jjmatchedPos = 0;
            }
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1)
{
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_2()
{
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_2(0x20000L);
      case 42:
         return jjMoveStringLiteralDfa1_2(0x800L);
      case 44:
         return jjMoveStringLiteralDfa1_2(0x10000L);
      case 45:
         return jjMoveStringLiteralDfa1_2(0x2000L);
      case 47:
         return jjMoveStringLiteralDfa1_2(0x1000L);
      case 92:
         return jjMoveStringLiteralDfa1_2(0x100000L);
      case 94:
         return jjMoveStringLiteralDfa1_2(0x8000L);
      case 95:
         return jjMoveStringLiteralDfa1_2(0x4000L);
      case 123:
         return jjMoveStringLiteralDfa1_2(0x100L);
      default :
         return jjMoveNfa_2(1, 0);
   }
}
private int jjMoveStringLiteralDfa1_2(long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 35:
         if ((active1 & 0x20000L) != 0L)
            return jjStopAtPos(1, 81);
         break;
      case 42:
         if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(1, 75);
         break;
      case 44:
         if ((active1 & 0x10000L) != 0L)
            return jjStopAtPos(1, 80);
         break;
      case 45:
         if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(1, 77);
         break;
      case 47:
         if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(1, 76);
         break;
      case 92:
         if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(1, 84);
         break;
      case 94:
         if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(1, 79);
         break;
      case 95:
         if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(1, 78);
         break;
      case 123:
         return jjMoveStringLiteralDfa2_2(active1, 0x100L);
      default :
         break;
   }
   return jjStartNfa_2(0, 0L, active1);
}
private int jjMoveStringLiteralDfa2_2(long old1, long active1)
{
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_2(0, 0L, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(1, 0L, active1);
      return 2;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x100L) != 0L)
            return jjStopAtPos(2, 72);
         break;
      default :
         break;
   }
   return jjStartNfa_2(1, 0L, active1);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 222;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 222:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(327, 331);
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(332, 336);
                  break;
               case 1:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(119, 120);
                  }
                  else if ((0xfc00fffe00000000L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 88)
                        kind = 88;
                     jjCheckNAddTwoStates(219, 220);
                  }
                  else if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     jjCheckNAddStates(337, 342);
                  }
                  if (curChar == 13)
                     jjAddStates(343, 344);
                  else if (curChar == 40)
                     jjCheckNAddStates(345, 347);
                  else if (curChar == 33)
                     jjAddStates(348, 349);
                  else if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 0:
                  if (curChar == 61 && kind > 10)
                     kind = 10;
                  break;
               case 4:
                  if (curChar == 58)
                     jjCheckNAddStates(350, 353);
                  break;
               case 6:
               case 7:
                  jjCheckNAddStates(350, 353);
                  break;
               case 20:
               case 21:
                  jjCheckNAddStates(354, 358);
                  break;
               case 27:
                  if (curChar != 58)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 28:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 30:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 31:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 32:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 38:
                  if (curChar != 58)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 39:
                  if ((0xfffffffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 41:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 42:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 43:
                  if ((0xfc00fffe00000000L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 50:
                  if (curChar == 58)
                     jjAddStates(359, 361);
                  break;
               case 51:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(362, 365);
                  break;
               case 52:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(366, 370);
                  break;
               case 53:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 54;
                  break;
               case 54:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 55:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(366, 370);
                  break;
               case 56:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(371, 375);
                  break;
               case 57:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(371, 375);
                  break;
               case 58:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 59:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 60:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(371, 375);
                  break;
               case 61:
                  if (curChar != 63)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(376, 378);
                  break;
               case 62:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(376, 378);
                  break;
               case 63:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 64:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 65:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(376, 378);
                  break;
               case 66:
                  if (curChar != 35)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 67:
                  if ((0xafffefd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 68:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 69:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 71:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 74:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 75:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 76:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(379, 383);
                  break;
               case 77:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(379, 383);
                  break;
               case 78:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(384, 388);
                  break;
               case 79:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(384, 388);
                  break;
               case 80:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 81:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 82:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(384, 388);
                  break;
               case 83:
                  if ((0x2bff6fd200000000L & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 91:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(389, 391);
                  break;
               case 92:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 93;
                  break;
               case 94:
                  if ((0x3ff680000000000L & l) != 0L)
                     jjCheckNAddStates(392, 394);
                  break;
               case 95:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(395, 402);
                  break;
               case 96:
                  if ((0x2fff6fd200000000L & l) != 0L)
                     jjCheckNAddStates(403, 405);
                  break;
               case 97:
                  if (curChar == 37)
                     jjCheckNAdd(98);
                  break;
               case 98:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 99:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(403, 405);
                  break;
               case 101:
                  if (curChar == 37)
                     jjCheckNAdd(102);
                  break;
               case 102:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 103:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(406, 411);
                  break;
               case 104:
                  if ((0x2bff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(406, 411);
                  break;
               case 105:
                  if (curChar == 58)
                     jjCheckNAdd(106);
                  break;
               case 106:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(412, 415);
                  break;
               case 107:
                  if (curChar != 47)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(416, 420);
                  break;
               case 108:
                  if ((0x2fff6fd200000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(416, 420);
                  break;
               case 109:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 110:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 111;
                  break;
               case 111:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(416, 420);
                  break;
               case 112:
                  if (curChar == 37)
                     jjCheckNAddTwoStates(98, 102);
                  break;
               case 113:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 95;
                  break;
               case 114:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 113;
                  break;
               case 115:
                  if (curChar != 41)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(116);
                  break;
               case 116:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 87)
                     kind = 87;
                  jjCheckNAdd(116);
                  break;
               case 117:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 115;
                  break;
               case 118:
                  if (curChar == 41)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 119:
                  if ((0x3ff0000ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(119, 120);
                  break;
               case 121:
                  if ((0xfc00fffe00000000L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 122:
                  if (curChar == 33)
                     jjAddStates(348, 349);
                  break;
               case 123:
                  if (curChar == 33 && kind > 11)
                     kind = 11;
                  break;
               case 124:
                  if (curChar == 40)
                     jjCheckNAddStates(345, 347);
                  break;
               case 125:
                  if (curChar == 37)
                     jjCheckNAddStates(421, 424);
                  break;
               case 127:
                  jjCheckNAddStates(421, 424);
                  break;
               case 128:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(421, 424);
                  break;
               case 129:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 130;
                  break;
               case 130:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(421, 424);
                  break;
               case 131:
                  if (curChar == 37)
                     jjAddStates(425, 426);
                  break;
               case 133:
                  if (curChar == 41)
                     jjCheckNAddStates(427, 430);
                  break;
               case 134:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddStates(427, 430);
                  break;
               case 135:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(136, 139);
                  break;
               case 136:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(136, 139);
                  break;
               case 137:
                  if (curChar == 40 && kind > 68)
                     kind = 68;
                  break;
               case 138:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 137;
                  break;
               case 139:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 138;
                  break;
               case 140:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 135;
                  break;
               case 141:
                  if ((0x2400L & l) != 0L)
                     jjCheckNAddTwoStates(136, 139);
                  break;
               case 142:
                  if (curChar == 37)
                     jjCheckNAddStates(431, 434);
                  break;
               case 144:
                  jjCheckNAddStates(431, 434);
                  break;
               case 145:
                  if ((0xffffffdfffffffffL & l) != 0L)
                     jjCheckNAddStates(431, 434);
                  break;
               case 146:
                  if (curChar == 37)
                     jjstateSet[jjnewStateCnt++] = 147;
                  break;
               case 147:
                  if ((0xfffffdffffffffffL & l) != 0L)
                     jjCheckNAddStates(431, 434);
                  break;
               case 148:
                  if (curChar == 37)
                     jjAddStates(435, 436);
                  break;
               case 150:
                  if (curChar == 41 && kind > 69)
                     kind = 69;
                  break;
               case 151:
                  if (curChar != 40)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(152);
                  break;
               case 152:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAdd(152);
                  break;
               case 153:
                  if (curChar == 40)
                     jjstateSet[jjnewStateCnt++] = 151;
                  break;
               case 154:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddStates(337, 342);
                  break;
               case 155:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(155, 156);
                  break;
               case 156:
                  if (curChar == 40)
                     jjCheckNAdd(153);
                  break;
               case 157:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 86)
                     kind = 86;
                  jjCheckNAddTwoStates(157, 158);
                  break;
               case 159:
                  if ((0x100000200L & l) != 0L)
                     jjCheckNAddTwoStates(159, 118);
                  break;
               case 162:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(332, 336);
                  break;
               case 163:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(164);
                  break;
               case 164:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(437, 441);
                  break;
               case 165:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(442, 448);
                  break;
               case 166:
                  if (curChar == 34)
                     jjCheckNAddStates(169, 171);
                  break;
               case 168:
                  jjCheckNAddStates(169, 171);
                  break;
               case 169:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(169, 171);
                  break;
               case 170:
                  if (curChar == 34)
                     jjCheckNAddStates(442, 448);
                  break;
               case 171:
                  if (curChar == 39)
                     jjCheckNAddStates(449, 451);
                  break;
               case 173:
                  jjCheckNAddStates(449, 451);
                  break;
               case 174:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(449, 451);
                  break;
               case 175:
                  if (curChar == 39)
                     jjCheckNAddStates(442, 448);
                  break;
               case 177:
               case 180:
                  jjCheckNAddStates(442, 448);
                  break;
               case 178:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(442, 448);
                  break;
               case 185:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 184;
                  break;
               case 186:
                  if (curChar == 10)
                     jjCheckNAddStates(442, 448);
                  break;
               case 187:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 186;
                  break;
               case 189:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(327, 331);
                  break;
               case 190:
                  if ((0x400600000000000L & l) != 0L)
                     jjCheckNAdd(191);
                  break;
               case 191:
                  if ((0x3ff0000ffffd9ffL & l) != 0L)
                     jjCheckNAddStates(452, 456);
                  break;
               case 192:
                  if ((0x100002600L & l) != 0L)
                     jjCheckNAddStates(457, 462);
                  break;
               case 193:
                  if (curChar == 34)
                     jjCheckNAddStates(186, 188);
                  break;
               case 195:
                  jjCheckNAddStates(186, 188);
                  break;
               case 196:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     jjCheckNAddStates(186, 188);
                  break;
               case 197:
                  if (curChar == 34)
                     jjCheckNAddStates(457, 462);
                  break;
               case 198:
                  if (curChar == 39)
                     jjCheckNAddStates(463, 465);
                  break;
               case 200:
                  jjCheckNAddStates(463, 465);
                  break;
               case 201:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     jjCheckNAddStates(463, 465);
                  break;
               case 202:
                  if (curChar == 39)
                     jjCheckNAddStates(457, 462);
                  break;
               case 204:
               case 207:
                  jjCheckNAddStates(457, 462);
                  break;
               case 205:
                  if ((0xffffff7bffffffffL & l) != 0L)
                     jjCheckNAddStates(457, 462);
                  break;
               case 211:
                  if (curChar == 10)
                     jjCheckNAddStates(457, 462);
                  break;
               case 212:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 211;
                  break;
               case 215:
                  if (curChar == 13)
                     jjAddStates(343, 344);
                  break;
               case 216:
                  if (curChar == 10 && kind > 88)
                     kind = 88;
                  break;
               case 217:
                  if (curChar == 10)
                     jjCheckNAddTwoStates(219, 220);
                  break;
               case 218:
                  if (curChar == 10 && kind > 91)
                     kind = 91;
                  break;
               case 219:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 218;
                  break;
               case 220:
                  if ((0x2400L & l) != 0L && kind > 91)
                     kind = 91;
                  break;
               case 221:
                  if ((0x2400L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjCheckNAddTwoStates(219, 220);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 222:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(327, 331);
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(332, 336);
                  break;
               case 161:
                  if (curChar == 123)
                     jjCheckNAdd(189);
                  if (curChar == 123)
                     jjCheckNAdd(162);
                  break;
               case 1:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                  {
                     if (kind > 89)
                        kind = 89;
                     jjCheckNAddTwoStates(119, 120);
                  }
                  else if ((0x78000001f8000001L & l) != 0L)
                  {
                     if (kind > 90)
                        kind = 90;
                  }
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(389, 391);
                  else if (curChar == 126)
                     jjCheckNAddStates(466, 468);
                  else if (curChar == 123)
                     jjAddStates(469, 470);
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 3;
                  else if (curChar == 124)
                  {
                     if (kind > 11)
                        kind = 11;
                  }
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 88;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 48;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 36;
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 2:
                  if (curChar == 124 && kind > 11)
                     kind = 11;
                  break;
               case 3:
                  if (curChar == 91)
                     jjCheckNAddStates(354, 358);
                  break;
               case 5:
               case 10:
                  if (curChar == 126)
                     jjCheckNAdd(6);
                  break;
               case 6:
                  jjCheckNAddStates(350, 353);
                  break;
               case 7:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(350, 353);
                  break;
               case 8:
                  if (curChar == 93)
                     jjCheckNAdd(7);
                  break;
               case 9:
                  if (curChar == 93)
                     jjAddStates(471, 472);
                  break;
               case 11:
                  if (curChar == 93)
                     jjCheckNAddStates(354, 358);
                  break;
               case 12:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 13:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
               case 24:
                  if (curChar == 126)
                     jjCheckNAdd(20);
                  break;
               case 20:
                  jjCheckNAddStates(354, 358);
                  break;
               case 21:
                  if ((0xbfffffffdfffffffL & l) != 0L)
                     jjCheckNAddStates(354, 358);
                  break;
               case 22:
                  if (curChar == 93)
                     jjCheckNAdd(21);
                  break;
               case 23:
                  if (curChar == 93)
                     jjAddStates(473, 474);
                  break;
               case 25:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 26:
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 28:
               case 30:
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 29:
                  if (curChar == 126)
                     jjAddStates(475, 477);
                  break;
               case 31:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 32:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 33:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 34:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 35:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 36:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 37:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 39:
               case 41:
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 40:
                  if (curChar == 126)
                     jjAddStates(478, 480);
                  break;
               case 42:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 43:
                  if ((0x78000001f8000001L & l) == 0L)
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 44:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 45:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 47:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 46;
                  break;
               case 48:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 49:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 48;
                  break;
               case 52:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(366, 370);
                  break;
               case 54:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 55:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(366, 370);
                  break;
               case 57:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(371, 375);
                  break;
               case 59:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 60:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(371, 375);
                  break;
               case 62:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(376, 378);
                  break;
               case 64:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 65:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(376, 378);
                  break;
               case 67:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 69:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 70:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddTwoStates(67, 68);
                  break;
               case 72:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 73:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 75:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 76:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(379, 383);
                  break;
               case 77:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(379, 383);
                  break;
               case 79:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(384, 388);
                  break;
               case 81:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 82:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(384, 388);
                  break;
               case 83:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddTwoStates(74, 77);
                  break;
               case 84:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 50;
                  break;
               case 85:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               case 88:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
               case 91:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(389, 391);
                  break;
               case 93:
               case 94:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(392, 394);
                  break;
               case 96:
                  if ((0x47fffffe87fffffeL & l) != 0L)
                     jjCheckNAddStates(403, 405);
                  break;
               case 98:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 99:
                  if ((0x7e0000007eL & l) != 0L)
                     jjCheckNAddStates(403, 405);
                  break;
               case 100:
                  if (curChar != 64)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(406, 411);
                  break;
               case 102:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 103:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(406, 411);
                  break;
               case 104:
                  if ((0x47fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(406, 411);
                  break;
               case 108:
                  if ((0x47fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(416, 420);
                  break;
               case 110:
                  if ((0x7e0000007eL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 111;
                  break;
               case 111:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 85)
                     kind = 85;
                  jjCheckNAddStates(416, 420);
                  break;
               case 119:
                  if ((0x87fffffe07fffffeL & l) == 0L)
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(119, 120);
                  break;
               case 120:
                  if (curChar == 126)
                     jjCheckNAdd(119);
                  break;
               case 121:
                  if ((0x78000001f8000001L & l) != 0L && kind > 90)
                     kind = 90;
                  break;
               case 126:
               case 132:
                  if (curChar == 126)
                     jjCheckNAdd(127);
                  break;
               case 127:
                  jjCheckNAddStates(421, 424);
                  break;
               case 128:
               case 130:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(421, 424);
                  break;
               case 143:
               case 149:
                  if (curChar == 126)
                     jjCheckNAdd(144);
                  break;
               case 144:
                  jjCheckNAddStates(431, 434);
                  break;
               case 145:
               case 147:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(431, 434);
                  break;
               case 158:
                  if (curChar == 126)
                     jjCheckNAdd(157);
                  break;
               case 160:
                  if (curChar == 123)
                     jjAddStates(469, 470);
                  break;
               case 162:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(332, 336);
                  break;
               case 163:
                  if (curChar == 95)
                     jjCheckNAdd(164);
                  break;
               case 164:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(437, 441);
                  break;
               case 167:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 168;
                  break;
               case 168:
                  jjCheckNAddStates(169, 171);
                  break;
               case 169:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(169, 171);
                  break;
               case 172:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 173;
                  break;
               case 173:
                  jjCheckNAddStates(449, 451);
                  break;
               case 174:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(449, 451);
                  break;
               case 176:
               case 181:
                  if (curChar == 126)
                     jjCheckNAdd(177);
                  break;
               case 177:
                  jjCheckNAddStates(442, 448);
                  break;
               case 178:
               case 180:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(442, 448);
                  break;
               case 179:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 180;
                  break;
               case 182:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 181;
                  break;
               case 183:
                  if (curChar == 125 && kind > 73)
                     kind = 73;
                  break;
               case 184:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 183;
                  break;
               case 188:
                  if (curChar == 123)
                     jjCheckNAdd(189);
                  break;
               case 189:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(327, 331);
                  break;
               case 190:
                  if (curChar == 95)
                     jjCheckNAdd(191);
                  break;
               case 191:
                  if ((0x87fffffe07fffffeL & l) != 0L)
                     jjCheckNAddStates(452, 456);
                  break;
               case 194:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 195;
                  break;
               case 195:
                  jjCheckNAddStates(186, 188);
                  break;
               case 196:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(186, 188);
                  break;
               case 199:
                  if (curChar == 126)
                     jjstateSet[jjnewStateCnt++] = 200;
                  break;
               case 200:
                  jjCheckNAddStates(463, 465);
                  break;
               case 201:
                  if ((0xbfffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(463, 465);
                  break;
               case 203:
               case 209:
                  if (curChar == 126)
                     jjCheckNAdd(204);
                  break;
               case 204:
                  jjCheckNAddStates(457, 462);
                  break;
               case 205:
               case 207:
                  if ((0x9fffffffffffffffL & l) != 0L)
                     jjCheckNAddStates(457, 462);
                  break;
               case 206:
                  if (curChar == 125)
                     jjstateSet[jjnewStateCnt++] = 207;
                  break;
               case 208:
                  if (curChar == 125)
                     jjCheckNAddTwoStates(209, 210);
                  break;
               case 210:
                  if (curChar == 125 && kind > 74)
                     kind = 74;
                  break;
               case 213:
                  if (curChar == 125)
                     jjCheckNAdd(210);
                  break;
               case 214:
                  if (curChar == 126)
                     jjCheckNAddStates(466, 468);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 222:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(332, 336);
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(327, 331);
                  break;
               case 1:
               case 119:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 89)
                     kind = 89;
                  jjCheckNAddTwoStates(119, 120);
                  break;
               case 6:
               case 7:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(350, 353);
                  break;
               case 20:
               case 21:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(354, 358);
                  break;
               case 28:
               case 30:
               case 31:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(28, 29);
                  break;
               case 39:
               case 41:
               case 42:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 83)
                     kind = 83;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 127:
               case 128:
               case 130:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(421, 424);
                  break;
               case 144:
               case 145:
               case 147:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(431, 434);
                  break;
               case 162:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(332, 336);
                  break;
               case 164:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(437, 441);
                  break;
               case 168:
               case 169:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(169, 171);
                  break;
               case 173:
               case 174:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(449, 451);
                  break;
               case 177:
               case 178:
               case 180:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(442, 448);
                  break;
               case 189:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(327, 331);
                  break;
               case 191:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(452, 456);
                  break;
               case 195:
               case 196:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(186, 188);
                  break;
               case 200:
               case 201:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(463, 465);
                  break;
               case 204:
               case 205:
               case 207:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjCheckNAddStates(457, 462);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 222 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   23, 0, 24, 2, 5, 8, 26, 36, 48, 13, 21, 2, 3, 4, 24, 2, 
   5, 8, 27, 29, 30, 32, 33, 34, 35, 14, 15, 20, 37, 39, 40, 42, 
   43, 44, 46, 47, 49, 51, 52, 54, 55, 56, 57, 63, 64, 62, 184, 185, 
   187, 207, 208, 157, 158, 160, 182, 180, 150, 151, 152, 153, 154, 115, 211, 212, 
   120, 137, 148, 2, 4, 5, 6, 15, 16, 18, 19, 20, 48, 68, 80, 49, 
   50, 58, 63, 49, 50, 53, 58, 63, 53, 54, 55, 58, 63, 59, 60, 63, 
   71, 74, 75, 58, 63, 75, 76, 77, 58, 63, 88, 89, 111, 89, 91, 111, 
   93, 97, 101, 102, 104, 58, 63, 109, 94, 93, 97, 98, 101, 102, 104, 58, 
   63, 103, 104, 58, 63, 104, 105, 106, 58, 63, 121, 123, 124, 126, 127, 128, 
   129, 135, 136, 134, 138, 140, 141, 143, 144, 145, 158, 159, 160, 182, 180, 161, 
   166, 171, 173, 174, 177, 180, 162, 164, 165, 167, 169, 170, 185, 186, 187, 207, 
   208, 188, 193, 198, 200, 201, 203, 189, 191, 192, 194, 196, 197, 152, 116, 118, 
   156, 183, 7, 8, 21, 22, 27, 28, 29, 38, 39, 40, 8, 9, 11, 31, 
   32, 9, 10, 11, 31, 32, 12, 17, 22, 24, 25, 27, 13, 15, 16, 18, 
   20, 21, 34, 35, 37, 39, 35, 36, 37, 39, 7, 40, 4, 5, 203, 204, 
   206, 226, 227, 176, 177, 179, 201, 199, 138, 139, 144, 145, 120, 121, 125, 126, 
   127, 131, 132, 133, 134, 115, 148, 165, 130, 137, 141, 142, 121, 123, 124, 149, 
   151, 152, 154, 155, 156, 157, 163, 164, 162, 166, 168, 169, 171, 172, 173, 177, 
   178, 179, 201, 199, 180, 185, 190, 192, 193, 196, 199, 181, 183, 184, 186, 188, 
   189, 204, 205, 206, 226, 227, 207, 212, 217, 219, 220, 222, 208, 210, 211, 213, 
   215, 216, 132, 116, 118, 175, 202, 189, 190, 192, 212, 213, 162, 163, 165, 187, 
   185, 155, 156, 157, 158, 159, 118, 216, 217, 125, 142, 153, 0, 123, 5, 7, 
   8, 9, 18, 19, 21, 22, 23, 51, 71, 83, 52, 53, 61, 66, 52, 53, 
   56, 61, 66, 56, 57, 58, 61, 66, 62, 63, 66, 74, 77, 78, 61, 66, 
   78, 79, 80, 61, 66, 91, 92, 114, 92, 94, 114, 96, 100, 104, 105, 107, 
   61, 66, 112, 97, 96, 100, 101, 104, 105, 107, 61, 66, 106, 107, 61, 66, 
   107, 108, 109, 61, 66, 126, 128, 129, 131, 132, 133, 134, 140, 141, 139, 143, 
   145, 146, 148, 149, 150, 163, 164, 165, 187, 185, 166, 171, 176, 178, 179, 182, 
   185, 172, 174, 175, 190, 191, 192, 212, 213, 193, 198, 203, 205, 206, 208, 199, 
   201, 202, 157, 119, 121, 161, 188, 10, 11, 24, 25, 30, 31, 32, 41, 42, 
   43, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, "\173\173\173", null, null, "\52\52", "\57\57", "\55\55", 
"\137\137", "\136\136", "\54\54", "\43\43", null, null, "\134\134", null, null, null, null, 
null, null, null, null, null, };

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "BEGINNING_OF_LINE",
   "TABLE_CONTEXT",
   "HEADER_CONTEXT",
   "VERBATIM_CONTEXT",
   "MACRO_CONTEXT",
   "INLINE",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, 1, -1, 6, 6, -1, -1, -1, 6, -1, -1, -1, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, 4, -1, 5, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, 1, 1, 1, 
};
static final long[] jjtoToken = {
   0x1ffdfdL, 0x3ffffff0L, 
};
static final long[] jjtoSkip = {
   0x202L, 0x0L, 
};
protected SimpleCharStream input_stream;
private final int[] jjrounds = new int[229];
private final int[] jjstateSet = new int[458];
private final StringBuilder jjimage = new StringBuilder();
private StringBuilder image = jjimage;
private int jjimageLen;
private int lengthOfMatch;
protected char curChar;
/** Constructor. */
public XWikiScannerTokenManager(SimpleCharStream stream){
   if (SimpleCharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}

/** Constructor. */
public XWikiScannerTokenManager(SimpleCharStream stream, int lexState){
   this(stream);
   SwitchTo(lexState);
}

/** Reinitialise parser. */
public void ReInit(SimpleCharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 229; i-- > 0;)
      jjrounds[i] = 0x80000000;
}

/** Reinitialise parser. */
public void ReInit(SimpleCharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}

/** Switch to specified lex state. */
public void SwitchTo(int lexState)
{
   if (lexState >= 7 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   if (jjmatchedPos < 0)
   {
      if (image == null)
         curTokenImage = "";
      else
         curTokenImage = image.toString();
      beginLine = endLine = input_stream.getBeginLine();
      beginColumn = endColumn = input_stream.getBeginColumn();
   }
   else
   {
      String im = jjstrLiteralImages[jjmatchedKind];
      curTokenImage = (im == null) ? input_stream.GetImage() : im;
      beginLine = input_stream.getBeginLine();
      beginColumn = input_stream.getBeginColumn();
      endLine = input_stream.getEndLine();
      endColumn = input_stream.getEndColumn();
   }
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(java.io.IOException e)
   {
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   switch(curLexState)
   {
     case 0:
       jjmatchedKind = 1;
       jjmatchedPos = -1;
       curPos = 0;
       curPos = jjMoveStringLiteralDfa0_0();
       break;
     case 1:
       jjmatchedKind = 9;
       jjmatchedPos = -1;
       curPos = 0;
       curPos = jjMoveStringLiteralDfa0_1();
       break;
     case 2:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_2();
       break;
     case 3:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_3();
       break;
     case 4:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_4();
       break;
     case 5:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_5();
       break;
     case 6:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_6();
       break;
   }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else
        {
           SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
  }
}

int[] jjemptyLineNo = new int[7];
int[] jjemptyColNo = new int[7];
boolean[] jjbeenHere = new boolean[7];
void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 1 :
         if (jjmatchedPos == -1)
         {
            if (jjbeenHere[0] &&
                jjemptyLineNo[0] == input_stream.getBeginLine() &&
                jjemptyColNo[0] == input_stream.getBeginColumn())
               throw new TokenMgrError(("Error: Bailing out of infinite loop caused by repeated empty string matches at line " + input_stream.getBeginLine() + ", column " + input_stream.getBeginColumn() + "."), TokenMgrError.LOOP_DETECTED);
            jjemptyLineNo[0] = input_stream.getBeginLine();
            jjemptyColNo[0] = input_stream.getBeginColumn();
            jjbeenHere[0] = true;
         }
         break;
      case 9 :
         if (jjmatchedPos == -1)
         {
            if (jjbeenHere[1] &&
                jjemptyLineNo[1] == input_stream.getBeginLine() &&
                jjemptyColNo[1] == input_stream.getBeginColumn())
               throw new TokenMgrError(("Error: Bailing out of infinite loop caused by repeated empty string matches at line " + input_stream.getBeginLine() + ", column " + input_stream.getBeginColumn() + "."), TokenMgrError.LOOP_DETECTED);
            jjemptyLineNo[1] = input_stream.getBeginLine();
            jjemptyColNo[1] = input_stream.getBeginColumn();
            jjbeenHere[1] = true;
         }
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        returnFromBeginningOfLine();
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 0 :
         break;
      case 2 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                enterBlockState(HEADER_CONTEXT);
         break;
      case 3 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                                                                    clearBlockState();
         break;
      case 4 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                 clearBlockState();
         break;
      case 5 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                             input_stream.backup(image.length()); enterBlockState(TABLE_CONTEXT);
         break;
      case 6 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               clearBlockState();
         break;
      case 7 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                          matchedToken.kind = NL;
         break;
      case 8 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                   clearBlockState();
         break;
      case 12 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                    clearBlockState();
         break;
      case 13 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          clearBlockState();
          matchedToken.kind = HEADER_END;
         break;
      case 14 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                              matchedToken.kind = HEADER_BEGIN;
         break;
      case 15 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          if (image.length() == 3) {
              verbatimBlockDepth++;
          }
          matchedToken.kind = VERBATIM_CONTENT;
         break;
      case 16 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          if (image.length() < 3) {
              matchedToken.kind = VERBATIM_CONTENT;
          } else {
              verbatimBlockDepth--;
              if (verbatimBlockDepth == 0)  {
                  returnFromSpecialState();
              } else {
                  matchedToken.kind = VERBATIM_CONTENT;
              }
          }
         break;
      case 18 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        {
            String name = getMacroName(image);
            if (name.equals(macroName)) {
                macroDepth++;
            }
            matchedToken.kind = MACRO_CONTENT;
        }
         break;
      case 19 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        {
            String name = getMacroName(image);
            if (name.equals(macroName)) {
                macroDepth--;
                if (macroDepth == 0) {
                    returnFromSpecialState();
                } else {
                     matchedToken.kind = MACRO_CONTENT;
                }
            } else {
                matchedToken.kind = MACRO_CONTENT;
            }
        }
         break;
      case 68 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                              input_stream.backup("(((".length());
         break;
      case 70 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                  pushControlState();
         break;
      case 72 :
        image.append(jjstrLiteralImages[72]);
        lengthOfMatch = jjstrLiteralImages[72].length();
                                 verbatimBlockDepth++;
         break;
      case 74 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                                         initMacro(image);
         break;
      case 87 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
       if (inEmbeddedDocument()) {
          popControlState();
       } else {
          /*
           * We must put back the spaces on the input stream.
           */
          String s = image.toString();
          int offset = s.indexOf(")))");
          if (offset > 0) {
             input_stream.backup(s.length() - offset);
             matchedToken.image = s.substring(0, offset);
             matchedToken.kind = XWIKI_SPACE;
          } else if (s.length() > ")))".length()) {
             matchedToken.image = s.substring(0, ")))".length());
             input_stream.backup(s.length() - ")))".length());
             matchedToken.kind = XWIKI_SPECIAL_SYMBOL;
          } else {
             matchedToken.kind = XWIKI_SPECIAL_SYMBOL;
          }
       }
         break;
      case 91 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                             clearBlockState();
         break;
      case 92 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              clearBlockState();
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

}
