/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XmlUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatXML(Document xml, Document xsl, URIResolver resolver, Writer output) throws Exception {
        try {
            DOMSource xslSource = new DOMSource(xsl);
            DOMSource xmlSource = new DOMSource(xml);
            StreamResult result = new StreamResult(output);
            XmlUtil.formatXML(xmlSource, xslSource, resolver, result);
        }
        finally {
            output.close();
        }
    }

    public static void formatXML(Document xml, Document xsl, Writer output) throws Exception {
        XmlUtil.formatXML(xml, xsl, null, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatXML(Reader xml, Reader xsl, URIResolver resolver, Writer output) throws Exception {
        try {
            try {
                try {
                    SAXSource xmlSource = new SAXSource(new InputSource(xml));
                    SAXSource xslSource = new SAXSource(new InputSource(xsl));
                    StreamResult result = new StreamResult(output);
                    XmlUtil.formatXML(xmlSource, xslSource, resolver, result);
                }
                finally {
                    output.close();
                }
            }
            finally {
                xsl.close();
            }
        }
        finally {
            xml.close();
        }
    }

    public static void formatXML(Reader xml, Reader xsl, Writer output) throws Exception {
        XmlUtil.formatXML(xml, xsl, null, output);
    }

    public static void formatXML(Source xmlSource, Source xslSource, URIResolver resolver, Result result) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates t = factory.newTemplates(xslSource);
        Transformer transformer = t.newTransformer();
        if (resolver != null) {
            transformer.setURIResolver(resolver);
        }
        transformer.transform(xmlSource, result);
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    public static String lookupNamespaceURI(Node root, String specifiedPrefix) {
        if (root == null) {
            return null;
        }
        if (root.hasAttributes()) {
            NamedNodeMap nnm = root.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node n = nnm.item(i);
                if ((!"xmlns".equals(n.getPrefix()) || !specifiedPrefix.equals(n.getNodeName())) && !("xmlns:" + specifiedPrefix).equals(n.getNodeName())) continue;
                return n.getNodeValue();
            }
        }
        return XmlUtil.lookupNamespaceURI(root.getParentNode(), specifiedPrefix);
    }

    public static <E extends Node> E newCopy(Document doc, E node) {
        Node result = node.cloneNode(true);
        return (E)doc.adoptNode(result);
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilder builder = XmlUtil.getDocumentBuilder();
        return builder.newDocument();
    }

    public static Element newTemplate(String xml) throws Exception {
        Document doc = XmlUtil.readXML(xml);
        return doc.getDocumentElement();
    }

    public static Document readXML(InputStream input) throws Exception {
        return XmlUtil.readXML(new InputStreamReader(input, "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readXML(Reader reader) throws Exception {
        try {
            Document doc;
            DocumentBuilder builder = XmlUtil.getDocumentBuilder();
            InputSource source = new InputSource(reader);
            Document document = doc = builder.parse(source);
            return document;
        }
        finally {
            reader.close();
        }
    }

    public static Document readXML(String str) throws Exception {
        if (str == null) {
            return null;
        }
        StringReader reader = new StringReader(str);
        return XmlUtil.readXML(reader);
    }

    public static String write(Document doc) throws Exception {
        return XmlUtil.write(doc.getDocumentElement());
    }

    public static String write(Element e) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtil.write(e, baos);
        return new String(baos.toByteArray(), "UTF-8");
    }

    public static void write(Element root, OutputStream os) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        XmlUtil.write(root, (Writer)writer);
    }

    public static void write(Element root, Writer writer) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource input = new DOMSource(root);
        XmlUtil.write((Source)input, writer);
    }

    public static void write(Reader reader, XMLReader parser, Result output) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        SAXSource input = new SAXSource();
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(reader);
        input.setInputSource(inputSource);
        input.setXMLReader(parser);
        XmlUtil.write((Source)input, output);
    }

    public static void write(Reader reader, XMLReader parser, Writer writer) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        StreamResult output = new StreamResult(writer);
        XmlUtil.write(reader, parser, output);
    }

    public static void write(Source input, Result output) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        XmlUtil.write(input, output, true);
    }

    public static void write(Source input, Result output, boolean indent) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        boolean omitxmldeclaration = true;
        Transformer idTransform = TransformerFactory.newInstance().newTransformer();
        if (omitxmldeclaration) {
            idTransform.setOutputProperty("omit-xml-declaration", "yes");
        }
        idTransform.setOutputProperty("encoding", "UTF-8");
        if (indent) {
            idTransform.setOutputProperty("indent", "yes");
            try {
                idTransform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        idTransform.transform(input, output);
    }

    public static void write(Source input, Writer writer) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        StreamResult output = new StreamResult(writer);
        XmlUtil.write(input, output);
    }
}

