/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xml.internal.parser;

import java.io.IOException;
import java.io.Reader;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.parser.xml.ContentHandlerStreamParser;
import org.xwiki.rendering.parser.xml.ContentHandlerStreamParserFactory;
import org.xwiki.xml.internal.LocalEntityResolver;

public abstract class AbstractStreamParser
implements ContentHandlerStreamParserFactory,
StreamParser,
Initializable {
    @Inject
    protected ComponentManager componentManager;
    private SAXParserFactory parserFactory;

    public void initialize() throws InitializationException {
        this.parserFactory = SAXParserFactory.newInstance();
        try {
            this.parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
        }
        catch (ParserConfigurationException e) {
            throw new InitializationException("Error configuring SAXParserFactory.", (Throwable)e);
        }
    }

    public ContentHandlerStreamParser createParser(Listener listener) {
        ContentHandlerStreamParser parser;
        try {
            parser = (ContentHandlerStreamParser)this.componentManager.getInstance(ContentHandlerStreamParser.class, this.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to create [" + this.getSyntax().toString() + "] ContentHandler stream parser", e);
        }
        parser.setListener(listener);
        return parser;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        try {
            this.parseXML(source, listener);
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse input source", (Throwable)e);
        }
    }

    public void parseXML(Reader source, Listener listener) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = this.parserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver((EntityResolver)new LocalEntityResolver());
        ContentHandlerStreamParser parser = this.createParser(listener);
        xmlReader.setContentHandler((ContentHandler)parser);
        xmlReader.parse(new InputSource(source));
    }
}

