/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.xml.internal.renderer;

import org.xml.sax.ContentHandler;
import org.xwiki.rendering.listener.chaining.AbstractChainingListener;
import org.xwiki.rendering.renderer.xml.ContentHandlerStreamRenderer;

/**
 * 
 * @version $Id: 22090e5b128ea4a39c626e8e75909461ba3b7420 $
 * @since 5.2M1
 */
public abstract class AbstractChainingContentHandlerStreamRenderer extends AbstractChainingListener implements
    ContentHandlerStreamRenderer
{
    /**
     * the object to send SAX events to.
     */
    private ContentHandler contentHandler;

    @Override
    public ContentHandler getContentHandler()
    {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler)
    {
        this.contentHandler = contentHandler;
    }
}
