/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.renderer.printer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultEntity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xwiki.rendering.internal.renderer.printer.WikiWriter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.xml.internal.renderer.printer.XHTMLWriter;
import org.xwiki.xml.XMLUtils;

public class XMLWikiPrinter {
    protected WikiWriter wikiWriter;
    protected XMLWriter xmlWriter;

    public XMLWikiPrinter(WikiPrinter printer) {
        this.wikiWriter = new WikiWriter(printer);
        this.xmlWriter = new XHTMLWriter((Writer)this.wikiWriter);
    }

    public XMLWriter getXMLWriter() {
        return this.xmlWriter;
    }

    public void setWikiPrinter(WikiPrinter printer) {
        this.wikiWriter.setWikiPrinter(printer);
    }

    public void printXML(String str) {
        try {
            this.xmlWriter.write(str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printXMLElement(String name) {
        this.printXMLElement(name, (String[][])null);
    }

    public void printXMLElement(String name, String[][] attributes) {
        DefaultElement element = new DefaultElement(name);
        if (attributes != null && attributes.length > 0) {
            for (String[] entry : attributes) {
                element.addAttribute(entry[0], entry[1]);
            }
        }
        try {
            this.xmlWriter.write((Element)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printXMLElement(String name, Map<String, String> attributes) {
        DefaultElement element = new DefaultElement(name);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                element.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.xmlWriter.write((Element)element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printXMLStartElement(String name) {
        this.printXMLStartElement(name, new AttributesImpl());
    }

    public void printXMLStartElement(String name, String[][] attributes) {
        this.printXMLStartElement(name, this.createAttributes(attributes));
    }

    public void printXMLStartElement(String name, Map<String, String> attributes) {
        this.printXMLStartElement(name, this.createAttributes(attributes));
    }

    public void printXMLStartElement(String name, Attributes attributes) {
        try {
            this.xmlWriter.startElement("", name, name, attributes);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void printXMLEndElement(String name) {
        try {
            this.xmlWriter.endElement("", name, name);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void printXMLComment(String content) {
        this.printXMLComment(content, false);
    }

    public void printXMLComment(String content, boolean escape) {
        try {
            this.xmlWriter.write((Comment)new DefaultComment(escape ? XMLUtils.escapeXMLComment((String)content) : content));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printXMLStartCData() {
        try {
            this.xmlWriter.startCDATA();
            this.xmlWriter.setEscapeText(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printXMLEndCData() {
        try {
            this.xmlWriter.setEscapeText(true);
            this.xmlWriter.endCDATA();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printEntity(String entity) {
        try {
            this.xmlWriter.write((Entity)new DefaultEntity(entity, entity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printRaw(String row) {
        try {
            this.wikiWriter.write(row);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Attributes createAttributes(String[][] parameters) {
        AttributesImpl attributes = new AttributesImpl();
        if (parameters != null && parameters.length > 0) {
            for (String[] entry : parameters) {
                attributes.addAttribute(null, null, entry[0], null, entry[1]);
            }
        }
        return attributes;
    }

    private Attributes createAttributes(Map<String, String> parameters) {
        AttributesImpl attributes = new AttributesImpl();
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String value = entry.getValue();
                String key = entry.getKey();
                if (key == null || value == null) continue;
                attributes.addAttribute(null, null, key, null, value);
            }
        }
        return attributes;
    }
}

